/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.migration.cli;

import java.io.File;
import org.apache.maven.model.Model;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.repositories.Repository;
import org.jboss.weld.environment.se.Weld;
import org.kie.workbench.common.migration.cli.ContainerHandler;
import org.kie.workbench.common.migration.cli.MigrationServicesCDIWrapper;
import org.kie.workbench.common.migration.cli.MigrationSetup;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;
import org.kie.workbench.common.project.migration.cli.PromptPomMigrationService;
import org.kie.workbench.common.project.migration.cli.maven.PomMigrationEditor;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.SimpleFileVisitor;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;

public class PomMigrationTool
implements MigrationTool {
    private final String POM_DOT_XML = "pom.xml";
    boolean systemMigrationCheck;
    private SystemAccess system;
    private ToolConfig config;

    public String getTitle() {
        return "POMs migration";
    }

    public String getDescription() {
        return "Migrates pom.xml files to format compatible with KIE Maven build.";
    }

    public Integer getPriority() {
        return 3;
    }

    public boolean isSystemMigration() {
        return false;
    }

    public void run(ToolConfig config, SystemAccess system) {
        this.config = config;
        this.system = system;
        if (this.projectMigrationWasExecuted()) {
            system.out().println("Starting POMs migration");
            this.migrate();
            system.out().println("Finished POMs migration, detailed log available in " + System.getProperty("user.dir") + "/migration_tool.log");
        }
    }

    private void migrate() {
        MigrationSetup.configureProperties((SystemAccess)this.system, (java.nio.file.Path)this.config.getTarget());
        PromptPomMigrationService promptPomMigrationService = new PromptPomMigrationService(this.system);
        String jsonPath = promptPomMigrationService.promptForExternalConfiguration();
        ContainerHandler container = new ContainerHandler(() -> new Weld().initialize());
        container.run(MigrationServicesCDIWrapper.class, cdiWrapper -> cdiWrapper.getWorkspaceProjectService().getAllWorkspaceProjects().forEach(pr -> this.processWorkspaceProject((WorkspaceProject)pr, jsonPath, (MigrationServicesCDIWrapper)cdiWrapper)), error -> {
            this.system.err().println("Error during migration: ");
            error.printStackTrace(this.system.err());
        });
        container.close();
    }

    private void processWorkspaceProject(WorkspaceProject workspaceProject, final String jsonPath, final MigrationServicesCDIWrapper cdiWrapper) {
        if (this.systemMigrationWasExecuted(cdiWrapper)) {
            final PomMigrationEditor editor = new PomMigrationEditor();
            final int[] counter = new int[]{0};
            Files.walkFileTree((Path)Paths.convert((org.uberfire.backend.vfs.Path)workspaceProject.getRootPath()), (FileVisitor)new SimpleFileVisitor<Path>(){

                public FileVisitResult visitFile(Path visitedPath, BasicFileAttributes attrs) throws IOException {
                    org.uberfire.backend.vfs.Path visitedVFSPath = Paths.convert((Path)visitedPath);
                    String fileName = visitedVFSPath.getFileName();
                    File file = visitedPath.toFile();
                    if (file.isFile() && fileName.equals("pom.xml")) {
                        try {
                            Model model = jsonPath.isEmpty() ? editor.updatePom(visitedPath, cdiWrapper) : editor.updatePom(visitedPath, jsonPath, cdiWrapper);
                            if (!model.getBuild().getPlugins().isEmpty()) {
                                counter[0] = counter[0] + 1;
                            }
                        }
                        catch (Exception e) {
                            PomMigrationTool.this.system.err().println("Error reading from filename [" + fileName + "] (error below).");
                            e.printStackTrace(PomMigrationTool.this.system.err());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            this.system.out().println("Migrated " + counter[0] + " POMs for project: " + workspaceProject.getName());
        }
    }

    private boolean projectMigrationWasExecuted() {
        if (!this.config.getTarget().resolve("system").resolve("system.git").toFile().exists()) {
            this.system.err().println(String.format("The PROJECT STRUCTURE MIGRATION must be ran before this one.", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean systemMigrationWasExecuted(MigrationServicesCDIWrapper cdiWrapper) {
        if (!this.systemMigrationCheck) {
            Repository systemRepository;
            this.systemMigrationCheck = true;
            IOService systemIoService = cdiWrapper.getSystemIoService();
            if (!systemIoService.exists(systemIoService.get((systemRepository = cdiWrapper.getSystemRepository()).getUri(), new String[0]).resolve("spaces"))) {
                this.system.err().println(String.format("The SYSTEM CONFIGURATION DIRECTORY STRUCTURE MIGRATION must be ran before this one.", new Object[0]));
                return false;
            }
            return true;
        }
        return true;
    }
}

