/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.config;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.events.RepositoryContributorsUpdatedEvent;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.backend.repositories.RepositoryServiceImpl;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.GitMetadataStore;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.project.config.Migration;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.SpacesAPI;

@Migration
@Service
@ApplicationScoped
public class MigrationRepositoryServiceImpl
extends RepositoryServiceImpl {
    private SpaceConfigStorageRegistry spaceConfigStorage;
    private IOService ioService;

    public MigrationRepositoryServiceImpl() {
    }

    @Inject
    public MigrationRepositoryServiceImpl(@Named(value="ioStrategy") IOService ioService, GitMetadataStore metadataStore, @Migration ConfigurationService configurationService, @Migration OrganizationalUnitService organizationalUnitService, @Migration ConfigurationFactory configurationFactory, RepositoryFactory repositoryFactory, Event<NewRepositoryEvent> event, Event<RepositoryRemovedEvent> repositoryRemovedEvent, BackwardCompatibleUtil backward, @Migration ConfiguredRepositories configuredRepositories, AuthorizationManager authorizationManager, User user, SpacesAPI spacesAPI, SpaceConfigStorageRegistry spaceConfigStorage, Event<RepositoryContributorsUpdatedEvent> projectContributorsUpdatedEvent) {
        super(ioService, metadataStore, configurationService, organizationalUnitService, configurationFactory, repositoryFactory, event, repositoryRemovedEvent, backward, configuredRepositories, authorizationManager, user, spacesAPI, spaceConfigStorage, projectContributorsUpdatedEvent);
        this.ioService = ioService;
        this.spaceConfigStorage = spaceConfigStorage;
    }

    public void deleteRepository(Repository repository) {
        Path path = this.getPath(repository);
        this.ioService.delete(path, new DeleteOption[0]);
        this.removeRepositoryFromSpaceInfo(repository);
    }

    private Path getPath(Repository repo) {
        Branch defaultBranch = (Branch)repo.getDefaultBranch().orElseThrow(() -> new IllegalStateException("Repository should have at least one branch."));
        return Paths.convert((org.uberfire.backend.vfs.Path)defaultBranch.getPath()).getFileSystem().getPath(null, new String[0]);
    }

    private void removeRepositoryFromSpaceInfo(Repository repo) {
        SpaceConfigStorage spaceConfigStorage = this.spaceConfigStorage.get(repo.getSpace().getName());
        SpaceInfo spaceInfo = this.spaceConfigStorage.get(repo.getSpace().getName()).loadSpaceInfo();
        spaceInfo.removeRepository(repo.getAlias());
        spaceConfigStorage.saveSpaceInfo(spaceInfo);
    }
}

