/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.kie.workbench.common.migration.cli.MigrationConstants;
import org.kie.workbench.common.migration.cli.SystemAccess;

public class ExternalMigrationService {
    private final SystemAccess system;

    public ExternalMigrationService(SystemAccess system) {
        this.system = system;
    }

    public void moveSystemRepos(Path niogitDir) throws SystemAccess.HaltingException {
        Path systemSpace = niogitDir.resolve("system");
        this.ensureSystemSpaceOrExit(systemSpace);
        this.system.out().println("Moving built-in repositories to system space...");
        Arrays.stream(MigrationConstants.systemRepos).forEach(oldRepoRelPath -> {
            Path oldRepoAbsPath = niogitDir.resolve((String)oldRepoRelPath);
            if (oldRepoAbsPath.toFile().exists()) {
                this.system.out().printf("Moving %s...\n", oldRepoRelPath);
                this.tryMovingRepo(systemSpace, (String)oldRepoRelPath, oldRepoAbsPath);
            }
        });
        this.system.out().println("Finished moving built-in repositories.");
    }

    private void ensureSystemSpaceOrExit(Path systemSpace) throws SystemAccess.HaltingException {
        if (!systemSpace.toFile().exists()) {
            try {
                this.system.createDirectory(systemSpace, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace(this.system.err());
                this.system.exit(1);
            }
        } else if (!systemSpace.toFile().isDirectory()) {
            new RuntimeException("Cannot create system space because of file: " + systemSpace).printStackTrace(this.system.err());
            this.system.exit(1);
        }
    }

    private void tryMovingRepo(Path systemSpace, String oldRepoRelPath, Path oldRepoAbsPath) {
        try {
            this.system.move(oldRepoAbsPath, systemSpace.resolve(oldRepoRelPath), new CopyOption[0]);
        }
        catch (IOException e) {
            this.system.err().println("Unable to move " + oldRepoAbsPath);
            e.printStackTrace(this.system.err());
        }
    }
}

