/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project;

import java.nio.file.Path;
import org.jboss.weld.environment.se.Weld;
import org.kie.workbench.common.migration.cli.ContainerHandler;
import org.kie.workbench.common.migration.cli.MigrationSetup;
import org.kie.workbench.common.migration.cli.MigrationTool;
import org.kie.workbench.common.migration.cli.NiogitDirUtil;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;
import org.kie.workbench.common.project.cli.ExternalMigrationService;
import org.kie.workbench.common.project.cli.InternalMigrationService;
import org.kie.workbench.common.project.cli.PromptService;

public class ProjectMigrationTool
implements MigrationTool {
    public static final String NAME = "Project structure migration";
    private SystemAccess system;
    private ToolConfig config;
    private Path niogitDir;

    public String getTitle() {
        return NAME;
    }

    public String getDescription() {
        return "Moves old project structure to new modules structure";
    }

    public Integer getPriority() {
        return 0;
    }

    public boolean isSystemMigration() {
        return true;
    }

    public void run(ToolConfig config, SystemAccess system) {
        this.config = config;
        this.system = system;
        this.niogitDir = config.getTarget();
        PromptService promptService = new PromptService(system, config);
        system.out().println("Starting project structure migration");
        if (this.validateTarget() && promptService.maybePromptForBackup()) {
            ExternalMigrationService externalService = new ExternalMigrationService(system);
            externalService.moveSystemRepos(this.niogitDir);
            MigrationSetup.configureProperties((SystemAccess)system, (Path)this.niogitDir);
            this.migrate();
        }
    }

    private boolean validateTarget() {
        if (NiogitDirUtil.isLegacyNiogitDir((Path)this.config.getTarget())) {
            return true;
        }
        this.system.err().println(String.format("The target path looks like it already contains an updated filesystem: %s", this.niogitDir));
        return false;
    }

    private void migrate() {
        ContainerHandler container = new ContainerHandler(() -> new Weld().initialize());
        container.run(InternalMigrationService.class, service -> service.migrateAllProjects(this.niogitDir), error -> {
            this.system.err().println("Error during migration: ");
            error.printStackTrace(this.system.err());
        });
        container.close();
    }
}

