/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.cli;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.kie.workbench.common.migration.cli.SystemAccess;
import org.kie.workbench.common.migration.cli.ToolConfig;

public class PromptService {
    private SystemAccess system;
    private ToolConfig config;
    private Path niogitDir;

    public PromptService(SystemAccess system, ToolConfig config) {
        this.system = system;
        this.config = config;
        this.niogitDir = config.getTarget();
    }

    public boolean maybePromptForBackup() {
        return this.config.isBatch() || this.promptForBackup();
    }

    private boolean promptForBackup() {
        String response;
        SystemAccess.Console console = this.system.console();
        console.format("WARNING: Please ensure that you have made backups of the directory [%s] before proceeding.\n", new Object[]{this.niogitDir});
        List<String> validResponses = Arrays.asList("yes", "no");
        while (!validResponses.contains(response = console.readLine("Do you wish to continue? [yes/no]: ", new Object[0]).toLowerCase())) {
        }
        return "yes".equals(response);
    }
}

