/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.config.ConfigGroupMarshaller;
import org.guvnor.structure.backend.config.ConfigurationServiceImpl;
import org.guvnor.structure.backend.config.OrgUnit;
import org.guvnor.structure.backend.config.watch.AsyncWatchServiceCallback;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.project.config.Migration;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Migration
@ApplicationScoped
public class MigrationConfigurationServiceImpl
extends ConfigurationServiceImpl
implements ConfigurationService,
AsyncWatchServiceCallback {
    public MigrationConfigurationServiceImpl() {
    }

    @Inject
    public MigrationConfigurationServiceImpl(@Named(value="system") Repository systemRepository, ConfigGroupMarshaller marshaller, User identity, @Named(value="configIO") IOService ioService, @org.guvnor.structure.backend.config.Repository Event<SystemRepositoryChangedEvent> repoChangedEvent, @OrgUnit Event<SystemRepositoryChangedEvent> orgUnitChangedEvent, Event<SystemRepositoryChangedEvent> changedEvent, @Named(value="systemFS") FileSystem fs) {
        super(systemRepository, marshaller, identity, ioService, repoChangedEvent, orgUnitChangedEvent, changedEvent, fs);
    }

    public List<ConfigGroup> getConfiguration(ConfigType configType) {
        if (ConfigType.SPACE.equals((Object)configType)) {
            configType = ConfigType.ORGANIZATIONAL_UNIT;
        }
        ConfigType type = configType;
        ArrayList<ConfigGroup> configGroups = new ArrayList<ConfigGroup>();
        DirectoryStream foundConfigs = this.ioService.newDirectoryStream(this.ioService.get(this.systemRepository.getUri(), new String[0]), entry -> !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && !entry.getFileName().toString().startsWith(".") && entry.getFileName().toString().endsWith(type.getExt()));
        Iterator it = foundConfigs.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                String content = this.ioService.readAllString((Path)it.next());
                ConfigGroup configGroup = this.marshaller.unmarshall(content);
                configGroups.add(configGroup);
            }
            this.configGroupsByTypeWithoutNamespace.put(type, configGroups);
        }
        return configGroups;
    }

    public List<ConfigGroup> getConfiguration(ConfigType type, String namespace) {
        if (ConfigType.SPACE.equals((Object)type)) {
            type = ConfigType.ORGANIZATIONAL_UNIT;
        }
        if (!ConfigType.REPOSITORY.equals((Object)type)) {
            return Collections.emptyList();
        }
        return this.getConfiguration(type).stream().filter(repoConfig -> namespace.equals(repoConfig.getConfigItemValue("space"))).collect(Collectors.toList());
    }

    public Map<String, List<ConfigGroup>> getConfigurationByNamespace(ConfigType type) {
        if (ConfigType.SPACE.equals((Object)type)) {
            type = ConfigType.ORGANIZATIONAL_UNIT;
        }
        if (!ConfigType.REPOSITORY.equals((Object)type)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<ConfigGroup>> repoConfigsBySpace = new HashMap<String, List<ConfigGroup>>();
        List<ConfigGroup> repoConfigs = this.getConfiguration(type);
        for (ConfigGroup repoConfig : repoConfigs) {
            String space = repoConfig.getConfigItemValue("space");
            if (space == null) continue;
            if (!repoConfigsBySpace.containsKey(space)) {
                repoConfigsBySpace.put(space, new ArrayList());
            }
            ((List)repoConfigsBySpace.get(space)).add(repoConfig);
        }
        return repoConfigsBySpace;
    }

    public boolean addConfiguration(ConfigGroup configGroup) {
        if (ConfigType.SPACE.equals((Object)configGroup.getType())) {
            configGroup.setType(ConfigType.ORGANIZATIONAL_UNIT);
        }
        String filename = configGroup.getName().replaceAll("[\\,/,:,*,?,\",<,>,|]", "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        if (this.ioService.exists(filePath)) {
            return true;
        }
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Created config " + filePath.getFileName());
        this.saveConfiguration(configGroup, filePath, commentedOption);
        this.configGroupsByTypeWithoutNamespace.remove(configGroup.getType());
        return true;
    }

    public boolean updateConfiguration(ConfigGroup configGroup) {
        if (ConfigType.SPACE.equals((Object)configGroup.getType())) {
            configGroup.setType(ConfigType.ORGANIZATIONAL_UNIT);
        }
        String filename = configGroup.getName().replaceAll("[\\,/,:,*,?,\",<,>,|]", "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        CommentedOption commentedOption = new CommentedOption(this.getIdentityName(), "Updated config " + filePath.getFileName());
        this.saveConfiguration(configGroup, filePath, commentedOption);
        this.configGroupsByTypeWithoutNamespace.remove(configGroup.getType());
        return true;
    }

    public boolean removeConfiguration(ConfigGroup configGroup) {
        boolean result;
        if (ConfigType.SPACE.equals((Object)configGroup.getType())) {
            configGroup.setType(ConfigType.ORGANIZATIONAL_UNIT);
        }
        this.configGroupsByTypeWithoutNamespace.remove(configGroup.getType());
        String filename = configGroup.getName().replaceAll("[\\,/,:,*,?,\",<,>,|]", "_");
        Path filePath = this.ioService.get(this.systemRepository.getUri(), new String[0]).resolve(filename + configGroup.getType().getExt());
        if (!this.ioService.exists(filePath)) {
            return true;
        }
        try {
            this.ioService.startBatch(filePath.getFileSystem());
            result = this.ioService.deleteIfExists(filePath, new DeleteOption[0]);
            if (result) {
                this.updateLastModified();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
        return result;
    }

    private void saveConfiguration(ConfigGroup configGroup, Path filePath, CommentedOption commentedOption) {
        try {
            this.ioService.startBatch(filePath.getFileSystem());
            this.ioService.write(filePath, this.marshaller.marshall(configGroup), new OpenOption[]{commentedOption});
            this.updateLastModified();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.ioService.endBatch();
        }
    }
}

