/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.adapter.binding;

import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapterProxy;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFactory;

import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFactory;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapterProxy;

@Generated("org.kie.workbench.common.stunner.core.processors.definition.BindableDefinitionAdapterGenerator")
@ApplicationScoped
public class DMNDefinitionSetDefinitionAdapterImpl extends org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapterProxy<Object> {

    private static final Map<Class, Class> baseTypes = new HashMap<Class, Class>(0) {{
    }};

    private static final Map<Class, String> idFieldNames = new HashMap<Class, String>(0) {{
    }};

    private static final Map<Class, String> categoryFieldNames = new HashMap<Class, String>(18) {{
            put( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.NOPDomainObject.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.Association.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.class, "stunnerCategory" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class, "stunnerCategory" );
    }};

    private static final Map<Class, String> titleFieldNames = new HashMap<Class, String>(0) {{
    }};

    private static final Map<Class, String> descriptionFieldNames = new HashMap<Class, String>(0) {{
    }};

    private static final Map<Class, String> labelsFieldNames = new HashMap<Class, String>(18) {{
              put( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.NOPDomainObject.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.Association.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.class, "stunnerLabels" );
              put( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class, "stunnerLabels" );
    }};

    private static final Map<Class, Class> graphFactoryFieldNames = new HashMap<Class, Class>(18) {{
            put( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.class, org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.NOPDomainObject.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.Association.class, org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement.class, org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class, org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class, org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class );
    }};

    private static final Map<Class, Set<String>> propertySetsFieldNames = new HashMap<Class, Set<String>>(8) {{
           put( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class, new HashSet<String>() {{
                    add ( "variable" );
                    add ( "backgroundSet" );
                    add ( "fontSet" );
                    add ( "dimensionsSet" );
            }} );
           put( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class, new HashSet<String>() {{
                    add ( "backgroundSet" );
                    add ( "fontSet" );
                    add ( "dimensionsSet" );
            }} );
           put( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class, new HashSet<String>() {{
                    add ( "variable" );
                    add ( "backgroundSet" );
                    add ( "fontSet" );
                    add ( "dimensionsSet" );
            }} );
           put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.class, new HashSet<String>() {{
                    add ( "outputValues" );
                    add ( "defaultOutputEntry" );
            }} );
           put( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class, new HashSet<String>() {{
                    add ( "definitions" );
            }} );
           put( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class, new HashSet<String>() {{
                    add ( "backgroundSet" );
                    add ( "fontSet" );
                    add ( "dimensionsSet" );
            }} );
           put( org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.class, new HashSet<String>() {{
                    add ( "inputValues" );
            }} );
           put( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class, new HashSet<String>() {{
                    add ( "variable" );
                    add ( "backgroundSet" );
                    add ( "fontSet" );
                    add ( "dimensionsSet" );
            }} );
    }};

    private static final Map<Class, Set<String>> propertiesFieldNames = new HashMap<Class, Set<String>>(14) {{
            put( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class, new HashSet<String>() {{
                add ( "text" );
                add ( "textFormat" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class, new HashSet<String>() {{
                add ( "name" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.class, new HashSet<String>() {{
                add ( "expressionLanguage" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class, new HashSet<String>() {{
                add ( "type" );
                add ( "locationURI" );
                add ( "name" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClauseLiteralExpression.class, new HashSet<String>() {{
                add ( "text" );
                add ( "expressionLanguage" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.Association.class, new HashSet<String>() {{
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class, new HashSet<String>() {{
                add ( "name" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause.class, new HashSet<String>() {{
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class, new HashSet<String>() {{
                add ( "id" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InputClause.class, new HashSet<String>() {{
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class, new HashSet<String>() {{
                add ( "expressionLanguage" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.class, new HashSet<String>() {{
                add ( "typeRefHolder" );
                add ( "name" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.class, new HashSet<String>() {{
                add ( "expressionLanguage" );
                add ( "name" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class, new HashSet<String>() {{
                add ( "question" );
                add ( "allowedAnswers" );
                add ( "name" );
                add ( "id" );
                add ( "description" );
            }} );
    }};

    private static final Map<org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes, Class> metaPropertyTypes = new HashMap<org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes, Class>(4) {{
            put( org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes.HEIGHT, org.kie.workbench.common.dmn.api.property.dimensions.Height.class );
            put( org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes.NAME, org.kie.workbench.common.dmn.api.property.dmn.Name.class );
            put( org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes.WIDTH, org.kie.workbench.common.dmn.api.property.dimensions.Width.class );
            put( org.kie.workbench.common.stunner.core.definition.property.PropertyMetaTypes.ID, org.kie.workbench.common.dmn.api.property.dmn.Id.class );
    }};

    private static final Map<Class, String> nameFields = new HashMap<Class, String>(5) {{
            put(org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class, "name");
            put(org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class, "text");
            put(org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class, "name");
            put(org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class, "name");
            put(org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class, "name");
    }};

    protected DMNDefinitionSetDefinitionAdapterImpl() {
    }

    @Inject
    public DMNDefinitionSetDefinitionAdapterImpl(org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    protected void setBindings(final BindableDefinitionAdapter<Object> adapter) {
        adapter.setBindings( metaPropertyTypes,
                baseTypes,
                propertySetsFieldNames,
                propertiesFieldNames,
                graphFactoryFieldNames,
                idFieldNames,
                labelsFieldNames,
                titleFieldNames,
                categoryFieldNames,
                descriptionFieldNames,
                nameFields);
    }

}
