/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;

public class DMNModelInstrumentedBaseTest {
    private static final String DUMMY_PREFIX = "dummy";
    private static final String DUMMY_URI = "http://http://www.kiegroup.org";

    @Test
    public void testParent() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        child.setParent(parent);
        Assert.assertEquals((Object)((Object)parent), (Object)child.getParent());
    }

    @Test
    public void testGetPrefixForNamespaceURIInheritance() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIOverride() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DUMMY_URI);
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DUMMY_URI);
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIDifferentPrefixInChildAndParent() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.getNsContext().put(DUMMY_PREFIX, DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DUMMY_PREFIX, childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIDifferentNothingInChild() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIDifferentNothingInParent() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        child.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertFalse((boolean)parentFeelPrefix.isPresent());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIMultipleNameSpaces() {
        MockDMNModelClass model = new MockDMNModelClass();
        model.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        model.getNsContext().put(DUMMY_PREFIX, DUMMY_URI);
        Optional modelFeelPrefix = model.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)modelFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), modelFeelPrefix.get());
        Optional modelDummyPrefix = model.getPrefixForNamespaceURI(DUMMY_URI);
        Assert.assertTrue((boolean)modelDummyPrefix.isPresent());
        Assert.assertEquals((Object)DUMMY_PREFIX, modelDummyPrefix.get());
    }

    public class MockDMNModelClass
    extends DMNModelInstrumentedBase {
    }
}

