/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.common.HasTypeRefHelper;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HasTypeRefHelper.class})
public class DecisionTableTest {
    private DecisionTable decisionTable;

    @Before
    public void setup() {
        this.decisionTable = (DecisionTable)Mockito.spy((Object)new DecisionTable());
    }

    @Test
    public void testDefaultHitPolicy() {
        Assert.assertEquals((Object)HitPolicy.UNIQUE, (Object)this.decisionTable.getHitPolicy());
    }

    @Test
    public void testGetHasTypeRefs() {
        List<InputClause> inputClauses = Arrays.asList((InputClause)Mockito.mock(InputClause.class), (InputClause)Mockito.mock(InputClause.class));
        List<OutputClause> outputClauses = Arrays.asList((OutputClause)Mockito.mock(OutputClause.class), (OutputClause)Mockito.mock(OutputClause.class));
        List<DecisionRule> decisionRules = Arrays.asList((DecisionRule)Mockito.mock(DecisionRule.class), (DecisionRule)Mockito.mock(DecisionRule.class));
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef5 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef6 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((DecisionTable)Mockito.doReturn(inputClauses).when((Object)this.decisionTable)).getInput();
        ((DecisionTable)Mockito.doReturn(outputClauses).when((Object)this.decisionTable)).getOutput();
        ((DecisionTable)Mockito.doReturn(decisionRules).when((Object)this.decisionTable)).getRule();
        PowerMockito.mockStatic(HasTypeRefHelper.class, (Class[])new Class[0]);
        PowerMockito.when((Object)HasTypeRefHelper.getFlatHasTypeRefs(inputClauses)).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        PowerMockito.when((Object)HasTypeRefHelper.getFlatHasTypeRefs(outputClauses)).thenReturn(Arrays.asList(hasTypeRef3, hasTypeRef4));
        PowerMockito.when((Object)HasTypeRefHelper.getFlatHasTypeRefs(decisionRules)).thenReturn(Arrays.asList(hasTypeRef5, hasTypeRef6));
        List actualHasTypeRefs = this.decisionTable.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.decisionTable, hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4, hasTypeRef5, hasTypeRef6);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.decisionTable.getRequiredComponentWidthCount(), (long)this.decisionTable.getComponentWidths().size());
        this.decisionTable.getComponentWidths().forEach(Assert::assertNull);
    }
}

