/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.common.HasTypeRefHelper;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HasTypeRefHelper.class})
public class DecisionRuleTest {
    private DecisionRule decisionRule;

    @Before
    public void setup() {
        this.decisionRule = (DecisionRule)Mockito.spy((Object)new DecisionRule());
    }

    @Test
    public void testGetHasTypeRefs() {
        LiteralExpression literalExpression1 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        LiteralExpression literalExpression2 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        List<LiteralExpression> outputEntry = Arrays.asList(literalExpression1, literalExpression2);
        ((DecisionRule)Mockito.doReturn(outputEntry).when((Object)this.decisionRule)).getOutputEntry();
        PowerMockito.mockStatic(HasTypeRefHelper.class, (Class[])new Class[0]);
        PowerMockito.when((Object)HasTypeRefHelper.getFlatHasTypeRefs(outputEntry)).thenReturn(Arrays.asList(literalExpression1, literalExpression2));
        List actualHasTypeRefs = this.decisionRule.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(literalExpression1, literalExpression2);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }
}

