/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.v1_1.Binding;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.common.HasTypeRefHelper;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HasTypeRefHelper.class})
public class BindingTest {
    private Binding binding;

    @Before
    public void setup() {
        this.binding = (Binding)Mockito.spy((Object)new Binding());
    }

    @Test
    public void testImplementsHasVariable() {
        Assert.assertTrue((boolean)(this.binding instanceof HasVariable));
    }

    @Test
    public void testHasVariableProxyGetter() {
        Assert.assertEquals((Object)this.binding.getParameter(), (Object)this.binding.getVariable());
    }

    @Test
    public void testHasVariableProxySetter() {
        InformationItem variable = new InformationItem();
        this.binding.setVariable(variable);
        Assert.assertEquals((Object)variable, (Object)this.binding.getParameter());
    }

    @Test
    public void testParameterSetter() {
        InformationItem variable = new InformationItem();
        this.binding.setParameter(variable);
        Assert.assertEquals((Object)variable, (Object)this.binding.getVariable());
    }

    @Test
    public void testGetHasTypeRefs() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        InformationItem parameter = (InformationItem)Mockito.mock(InformationItem.class);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((Binding)Mockito.doReturn((Object)expression).when((Object)this.binding)).getExpression();
        ((Binding)Mockito.doReturn((Object)parameter).when((Object)this.binding)).getParameter();
        PowerMockito.mockStatic(HasTypeRefHelper.class, (Class[])new Class[0]);
        PowerMockito.when((Object)HasTypeRefHelper.getNotNullHasTypeRefs((HasTypeRef)expression)).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        PowerMockito.when((Object)HasTypeRefHelper.getNotNullHasTypeRefs((HasTypeRef)parameter)).thenReturn(Arrays.asList(hasTypeRef3, hasTypeRef4));
        List actualHasTypeRefs = this.binding.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }
}

