/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.api.definition.v1_1.common.HasTypeRefHelper;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HasTypeRefHelper.class})
public class RelationTest {
    private Relation relation;

    @Before
    public void setup() {
        this.relation = (Relation)Mockito.spy((Object)new Relation());
    }

    @Test
    public void testGetHasTypeRefs() {
        java.util.List<InformationItem> column = Arrays.asList((InformationItem)Mockito.mock(InformationItem.class), (InformationItem)Mockito.mock(InformationItem.class));
        java.util.List<List> row = Arrays.asList((List)Mockito.mock(List.class), (List)Mockito.mock(List.class));
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((Relation)Mockito.doReturn(column).when((Object)this.relation)).getColumn();
        ((Relation)Mockito.doReturn(row).when((Object)this.relation)).getRow();
        PowerMockito.mockStatic(HasTypeRefHelper.class, (Class[])new Class[0]);
        PowerMockito.when((Object)HasTypeRefHelper.getFlatHasTypeRefs(column)).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        PowerMockito.when((Object)HasTypeRefHelper.getFlatHasTypeRefs(row)).thenReturn(Arrays.asList(hasTypeRef3, hasTypeRef4));
        java.util.List actualHasTypeRefs = this.relation.getHasTypeRefs();
        java.util.List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.relation, hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.relation.getRequiredComponentWidthCount(), (long)this.relation.getComponentWidths().size());
        this.relation.getComponentWidths().forEach(Assert::assertNull);
    }
}

