/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TextAnnotationTest {
    private TextAnnotation textAnnotation;
    private static final String[] READONLY_FIELDS = new String[]{"Description", "Text", "TextFormat"};

    @Before
    public void setup() {
        this.textAnnotation = new TextAnnotation();
    }

    @Test
    public void testGetReadOnlyNotSet() {
        this.textAnnotation.setAllowOnlyVisualChange(false);
        this.checkIfItIsNotSet("something");
    }

    @Test
    public void testGetReadOnlyWithReadOnlyValuesAndAllowOnlyVisualChangesNotSet() {
        this.textAnnotation.setAllowOnlyVisualChange(false);
        for (String readonlyField : READONLY_FIELDS) {
            this.checkIfItIsNotSet(readonlyField);
        }
    }

    private void checkIfItIsNotSet(String property) {
        DynamicReadOnly.ReadOnly actual = this.textAnnotation.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.NOT_SET, (Object)actual);
    }

    @Test
    public void testGetReadOnlyWithReadOnlyValues() {
        this.textAnnotation.setAllowOnlyVisualChange(true);
        for (String readonlyField : READONLY_FIELDS) {
            this.checkIfIsReadOnly(readonlyField);
        }
    }

    private void checkIfIsReadOnly(String property) {
        DynamicReadOnly.ReadOnly actual = this.textAnnotation.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.TRUE, (Object)actual);
    }

    @Test
    public void testGetReadOnlyWithNotReadOnlyValues() {
        this.textAnnotation.setAllowOnlyVisualChange(true);
        this.checkIfItIsNotReadOnly("Font");
        this.checkIfItIsNotReadOnly("Something");
    }

    private void checkIfItIsNotReadOnly(String property) {
        DynamicReadOnly.ReadOnly actual = this.textAnnotation.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.FALSE, (Object)actual);
    }
}

