/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.IsInformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement;
import org.kie.workbench.common.dmn.api.property.DMNPropertySet;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.QNameFieldType;
import org.kie.workbench.common.dmn.api.property.dmn.QNameHolder;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormDefinition;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.forms.adf.definitions.settings.FieldPolicy;
import org.kie.workbench.common.stunner.core.definition.annotation.Definition;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.PropertySet;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Category;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Labels;
import org.kie.workbench.common.stunner.core.factory.graph.NodeFactory;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
@Bindable
@PropertySet
@Definition(graphFactory=NodeFactory.class)
@FormDefinition(policy=FieldPolicy.ONLY_MARKED, startElement="id")
public class InformationItem
extends NamedElement
implements DMNPropertySet,
IsInformationItem {
    @Category
    private static final String stunnerCategory = "DMNDomainObjects";
    @Labels
    private static final Set<String> stunnerLabels = new Sets.Builder().build();
    protected QName typeRef;
    @Property
    @FormField(afterElement="name", type=QNameFieldType.class)
    @Valid
    protected QNameHolder typeRefHolder;

    public InformationItem() {
        this(new Id(), new Description(), new Name(), new QName());
    }

    public InformationItem(Id id, Description description, Name name, QName typeRef) {
        super(id, description, name);
        this.typeRef = typeRef;
        this.typeRefHolder = new QNameHolder(typeRef);
    }

    public String getStunnerCategory() {
        return stunnerCategory;
    }

    public Set<String> getStunnerLabels() {
        return stunnerLabels;
    }

    @Override
    public QName getTypeRef() {
        return this.typeRefHolder.getValue();
    }

    @Override
    public void setTypeRef(QName typeRef) {
        this.typeRefHolder.setValue(typeRef);
    }

    @Override
    public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
        return this;
    }

    @Override
    public List<HasTypeRef> getHasTypeRefs() {
        return new ArrayList<HasTypeRef>(Collections.singletonList(this));
    }

    public QNameHolder getTypeRefHolder() {
        return this.typeRefHolder;
    }

    public void setTypeRefHolder(QNameHolder typeRefHolder) {
        this.typeRefHolder = typeRefHolder;
    }

    public String getDomainObjectUUID() {
        return this.getId().getValue();
    }

    public String getDomainObjectNameTranslationKey() {
        return "InformationItemPrimary.DomainObjectName";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InformationItem)) {
            return false;
        }
        InformationItem that = (InformationItem)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.typeRef != null ? !this.typeRef.equals(that.typeRef) : that.typeRef != null) {
            return false;
        }
        return this.typeRefHolder != null ? this.typeRefHolder.equals(that.typeRefHolder) : that.typeRefHolder == null;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.id != null ? this.id.hashCode() : 0, this.description != null ? this.description.hashCode() : 0, this.name != null ? this.name.hashCode() : 0, this.typeRef != null ? this.typeRef.hashCode() : 0, this.typeRefHolder != null ? this.typeRefHolder.hashCode() : 0});
    }
}

