/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;

public class ImportPMMLTest {
    @Test
    public void testNameObjectZeroParameterConstructor() {
        ImportPMML anImport = new ImportPMML();
        this.doNameObjectTest(anImport);
    }

    @Test
    public void testNameObjectParameterConstructor() {
        ImportPMML anImport = new ImportPMML("namespace", new LocationURI(), DMNImportTypes.PMML.getDefaultNamespace());
        Assert.assertEquals((Object)"namespace", (Object)anImport.getName().getValue());
        this.doNameObjectTest(anImport);
    }

    private void doNameObjectTest(ImportPMML anImport) {
        anImport.setName(new Name("name"));
        Assert.assertEquals((Object)"name", (Object)anImport.getName().getValue());
        Assert.assertEquals((Object)"name", (Object)anImport.getNamespace());
    }

    @Test
    public void testNameValueZeroParameterConstructor() {
        ImportPMML anImport = new ImportPMML();
        this.doNameValueTest(anImport);
    }

    @Test
    public void testNameValueParameterConstructor() {
        ImportPMML anImport = new ImportPMML("namespace", new LocationURI(), DMNImportTypes.PMML.getDefaultNamespace());
        Assert.assertEquals((Object)"namespace", (Object)anImport.getName().getValue());
        this.doNameValueTest(anImport);
    }

    private void doNameValueTest(ImportPMML anImport) {
        anImport.getName().setValue("name");
        Assert.assertEquals((Object)"name", (Object)anImport.getName().getValue());
        Assert.assertEquals((Object)"name", (Object)anImport.getNamespace());
    }

    @Test
    public void testNamespaceZeroParameterConstructor() {
        ImportPMML anImport = new ImportPMML();
        this.doNamespaceTest(anImport);
    }

    @Test
    public void testNamespaceParameterConstructor() {
        ImportPMML anImport = new ImportPMML("original", new LocationURI(), DMNImportTypes.PMML.getDefaultNamespace());
        Assert.assertEquals((Object)"original", (Object)anImport.getName().getValue());
        this.doNamespaceTest(anImport);
    }

    private void doNamespaceTest(ImportPMML anImport) {
        anImport.setNamespace("namespace");
        Assert.assertEquals((Object)"namespace", (Object)anImport.getName().getValue());
        Assert.assertEquals((Object)"namespace", (Object)anImport.getNamespace());
    }

    @Test
    public void testIdentity() {
        ImportPMML anImport = new ImportPMML();
        Name expectedName = anImport.getName();
        anImport.setName(expectedName);
        Assert.assertTrue((expectedName == anImport.getName() ? 1 : 0) != 0);
    }

    @Test
    public void testEquality() {
        ImportPMML anImport = new ImportPMML();
        Name expectedName = anImport.getName();
        anImport.setName(expectedName);
        Assert.assertEquals((Object)expectedName, (Object)anImport.getName());
    }
}

