/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.adapter.binding;

import org.kie.workbench.common.stunner.core.definition.adapter.AbstractDefinitionSetRuleAdapter;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleSetImpl;
import org.kie.workbench.common.stunner.core.rule.context.*;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.impl.CanConnect;
import org.kie.workbench.common.stunner.core.rule.impl.CanContain;
import org.kie.workbench.common.stunner.core.rule.impl.CanDock;
import org.kie.workbench.common.stunner.core.rule.impl.EdgeOccurrences;
import org.kie.workbench.common.stunner.core.rule.impl.Occurrences;

import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@Generated("org.kie.workbench.common.stunner.core.processors.rule.BindableDefinitionSetRuleAdapterGenerator")
@ApplicationScoped
public class DMNDefinitionSetRuleAdapterImpl extends org.kie.workbench.common.stunner.core.definition.adapter.AbstractDefinitionSetRuleAdapter<org.kie.workbench.common.dmn.api.DMNDefinitionSet> {

        
CanContain  dMNDiagramContainmentRule = new CanContain("dMNDiagramContainmentRule", "org.kie.workbench.common.dmn.api.definition.model.DMNDiagram", new HashSet<String>(10) {{
        add( "input-data" );
        add( "knowledge-source" );
        add( "business-knowledge-model" );
        add( "decision" );
        add( "text-annotation" );
        add( "association" );
        add( "information-requirement" );
        add( "knowledge-requirement" );
        add( "authority-requirement" );
        add( "decision-service" );
}});


        
CanContain  decisionServiceContainmentRule = new CanContain("decisionServiceContainmentRule", "org.kie.workbench.common.dmn.api.definition.model.DecisionService", new HashSet<String>(1) {{
        add( "decision" );
}});


        
CanContain  dMNDefinitionSetContainmentRule = new CanContain("dMNDefinitionSetContainmentRule", "org.kie.workbench.common.dmn.api.DMNDefinitionSet", new HashSet<String>(1) {{
        add( "dmn_diagram" );
}});


        RuleExtension associationExtRule_acyclicDirectedGraphRule = new RuleExtension("associationExtRule_acyclicDirectedGraphRule", "org.kie.workbench.common.dmn.api.definition.model.Association").setHandlerType(org.kie.workbench.common.dmn.api.rules.AcyclicDirectedGraphRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] { org.kie.workbench.common.dmn.api.definition.model.Association.class });
        RuleExtension associationExtRule_singleConnectorPerTypeGraphRule = new RuleExtension("associationExtRule_singleConnectorPerTypeGraphRule", "org.kie.workbench.common.dmn.api.definition.model.Association").setHandlerType(org.kie.workbench.common.dmn.api.rules.SingleConnectorPerTypeGraphRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] { org.kie.workbench.common.dmn.api.definition.model.Association.class });
        RuleExtension informationRequirementExtRule_acyclicDirectedGraphRule = new RuleExtension("informationRequirementExtRule_acyclicDirectedGraphRule", "org.kie.workbench.common.dmn.api.definition.model.InformationRequirement").setHandlerType(org.kie.workbench.common.dmn.api.rules.AcyclicDirectedGraphRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] { org.kie.workbench.common.dmn.api.definition.model.InformationRequirement.class });
        RuleExtension informationRequirementExtRule_singleConnectorPerTypeGraphRule = new RuleExtension("informationRequirementExtRule_singleConnectorPerTypeGraphRule", "org.kie.workbench.common.dmn.api.definition.model.InformationRequirement").setHandlerType(org.kie.workbench.common.dmn.api.rules.SingleConnectorPerTypeGraphRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] { org.kie.workbench.common.dmn.api.definition.model.InformationRequirement.class });
        RuleExtension authorityRequirementExtRule_acyclicDirectedGraphRule = new RuleExtension("authorityRequirementExtRule_acyclicDirectedGraphRule", "org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement").setHandlerType(org.kie.workbench.common.dmn.api.rules.AcyclicDirectedGraphRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] { org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement.class });
        RuleExtension authorityRequirementExtRule_singleConnectorPerTypeGraphRule = new RuleExtension("authorityRequirementExtRule_singleConnectorPerTypeGraphRule", "org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement").setHandlerType(org.kie.workbench.common.dmn.api.rules.SingleConnectorPerTypeGraphRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] { org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement.class });
        RuleExtension knowledgeRequirementExtRule_acyclicDirectedGraphRule = new RuleExtension("knowledgeRequirementExtRule_acyclicDirectedGraphRule", "org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement").setHandlerType(org.kie.workbench.common.dmn.api.rules.AcyclicDirectedGraphRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] { org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement.class });
        RuleExtension knowledgeRequirementExtRule_singleConnectorPerTypeGraphRule = new RuleExtension("knowledgeRequirementExtRule_singleConnectorPerTypeGraphRule", "org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement").setHandlerType(org.kie.workbench.common.dmn.api.rules.SingleConnectorPerTypeGraphRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] { org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement.class });
        RuleExtension dRGElementExtRule_noInputNodesInImportedDecisionRule = new RuleExtension("dRGElementExtRule_noInputNodesInImportedDecisionRule", "org.kie.workbench.common.dmn.api.definition.model.DRGElement").setHandlerType(org.kie.workbench.common.dmn.api.rules.NoInputNodesInImportedDecisionRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] {  });
        RuleExtension businessKnowledgeModelExtRule_noInputNodesInImportedDecisionRule = new RuleExtension("businessKnowledgeModelExtRule_noInputNodesInImportedDecisionRule", "org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel").setHandlerType(org.kie.workbench.common.dmn.api.rules.NoInputNodesInImportedDecisionRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] {  });
        RuleExtension decisionServiceExtRule_noInputNodesInImportedDecisionRule = new RuleExtension("decisionServiceExtRule_noInputNodesInImportedDecisionRule", "org.kie.workbench.common.dmn.api.definition.model.DecisionService").setHandlerType(org.kie.workbench.common.dmn.api.rules.NoInputNodesInImportedDecisionRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] {  });
        RuleExtension decisionExtRule_noInputNodesInImportedDecisionRule = new RuleExtension("decisionExtRule_noInputNodesInImportedDecisionRule", "org.kie.workbench.common.dmn.api.definition.model.Decision").setHandlerType(org.kie.workbench.common.dmn.api.rules.NoInputNodesInImportedDecisionRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] {  });
        RuleExtension inputDataExtRule_noInputNodesInImportedDecisionRule = new RuleExtension("inputDataExtRule_noInputNodesInImportedDecisionRule", "org.kie.workbench.common.dmn.api.definition.model.InputData").setHandlerType(org.kie.workbench.common.dmn.api.rules.NoInputNodesInImportedDecisionRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] {  });
        RuleExtension knowledgeSourceExtRule_noInputNodesInImportedDecisionRule = new RuleExtension("knowledgeSourceExtRule_noInputNodesInImportedDecisionRule", "org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource").setHandlerType(org.kie.workbench.common.dmn.api.rules.NoInputNodesInImportedDecisionRule.class).setArguments(new String[] {  }).setTypeArguments(new Class<?>[] {  });
        
CanConnect associationConnectionRule = new CanConnect("associationConnectionRule", "org.kie.workbench.common.dmn.api.definition.model.Association",
    new ArrayList<CanConnect.PermittedConnection>(4) {{
        add(new CanConnect.PermittedConnection( "business-knowledge-model", "text-annotation" ));
        add(new CanConnect.PermittedConnection( "decision", "text-annotation" ));
        add(new CanConnect.PermittedConnection( "input-data", "text-annotation" ));
        add(new CanConnect.PermittedConnection( "knowledge-source", "text-annotation" ));
    }}
);
        
CanConnect informationRequirementConnectionRule = new CanConnect("informationRequirementConnectionRule", "org.kie.workbench.common.dmn.api.definition.model.InformationRequirement",
    new ArrayList<CanConnect.PermittedConnection>(2) {{
        add(new CanConnect.PermittedConnection( "decision", "decision" ));
        add(new CanConnect.PermittedConnection( "input-data", "decision" ));
    }}
);
        
CanConnect authorityRequirementConnectionRule = new CanConnect("authorityRequirementConnectionRule", "org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement",
    new ArrayList<CanConnect.PermittedConnection>(4) {{
        add(new CanConnect.PermittedConnection( "knowledge-source", "decision" ));
        add(new CanConnect.PermittedConnection( "knowledge-source", "business-knowledge-model" ));
        add(new CanConnect.PermittedConnection( "knowledge-source", "knowledge-source" ));
        add(new CanConnect.PermittedConnection( "input-data", "knowledge-source" ));
    }}
);
        
CanConnect knowledgeRequirementConnectionRule = new CanConnect("knowledgeRequirementConnectionRule", "org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement",
    new ArrayList<CanConnect.PermittedConnection>(4) {{
        add(new CanConnect.PermittedConnection( "business-knowledge-model", "decision" ));
        add(new CanConnect.PermittedConnection( "business-knowledge-model", "business-knowledge-model" ));
        add(new CanConnect.PermittedConnection( "decision-service", "decision" ));
        add(new CanConnect.PermittedConnection( "decision-service", "business-knowledge-model" ));
    }}
);

    private static final Set<Rule> rules = new HashSet<Rule>(21);
    private RuleSet ruleSet;

    @PostConstruct
    public void init() {
            rules.add(dMNDiagramContainmentRule);
            rules.add(decisionServiceContainmentRule);
            rules.add(dMNDefinitionSetContainmentRule);
            rules.add(associationExtRule_acyclicDirectedGraphRule);
            rules.add(associationExtRule_singleConnectorPerTypeGraphRule);
            rules.add(informationRequirementExtRule_acyclicDirectedGraphRule);
            rules.add(informationRequirementExtRule_singleConnectorPerTypeGraphRule);
            rules.add(authorityRequirementExtRule_acyclicDirectedGraphRule);
            rules.add(authorityRequirementExtRule_singleConnectorPerTypeGraphRule);
            rules.add(knowledgeRequirementExtRule_acyclicDirectedGraphRule);
            rules.add(knowledgeRequirementExtRule_singleConnectorPerTypeGraphRule);
            rules.add(dRGElementExtRule_noInputNodesInImportedDecisionRule);
            rules.add(businessKnowledgeModelExtRule_noInputNodesInImportedDecisionRule);
            rules.add(decisionServiceExtRule_noInputNodesInImportedDecisionRule);
            rules.add(decisionExtRule_noInputNodesInImportedDecisionRule);
            rules.add(inputDataExtRule_noInputNodesInImportedDecisionRule);
            rules.add(knowledgeSourceExtRule_noInputNodesInImportedDecisionRule);
            rules.add(associationConnectionRule);
            rules.add(informationRequirementConnectionRule);
            rules.add(authorityRequirementConnectionRule);
            rules.add(knowledgeRequirementConnectionRule);
        ruleSet = new RuleSetImpl("DMNDefinitionSetRuleAdapterImpl", rules);
    }

    @Override
    public RuleSet getRuleSet( final org.kie.workbench.common.dmn.api.DMNDefinitionSet pojo ) {
        return ruleSet;
    }

    @Override
    public boolean accepts( final Class<?> type ) {
        return org.kie.workbench.common.dmn.api.DMNDefinitionSet.class.equals( type );
    }

}
