/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.rules.AcyclicDirectedGraphWalker;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AcyclicDirectedGraphWalkerTest {
    @Mock
    private TreeTraverseCallback callback;
    @Captor
    private ArgumentCaptor<Node> nodeStartVisitCaptor;
    @Captor
    private ArgumentCaptor<Node> nodeEndVisitCaptor;
    @Captor
    private ArgumentCaptor<Edge> edgeStartVisitCaptor;
    @Captor
    private ArgumentCaptor<Edge> edgeEndVisitCaptor;
    private GraphImpl graph = new GraphImpl("uuid", (GraphNodeStore)new GraphNodeStoreImpl());
    private TreeWalkTraverseProcessor walker;

    @Before
    public void setup() {
        Mockito.when((Object)this.callback.startNodeTraversal((Node)Mockito.any(Node.class))).thenReturn((Object)true);
        Mockito.when((Object)this.callback.startEdgeTraversal((Edge)Mockito.any(Edge.class))).thenReturn((Object)true);
    }

    @Test
    public void checkSimpleWalk() {
        NodeImpl node1 = new NodeImpl("node1");
        NodeImpl node2 = new NodeImpl("node2");
        NodeImpl node3 = new NodeImpl("node3");
        EdgeImpl c1 = new EdgeImpl("edge1:node1-node2");
        EdgeImpl c2 = new EdgeImpl("edge2:node2-node3");
        this.connectNodes((Node)node1, (Node)node2, (Edge)c1);
        this.graph.addNode((Node)node1);
        this.graph.addNode((Node)node2);
        this.walker = new AcyclicDirectedGraphWalker((Node)node2, (Node)node3, (Edge)c2);
        this.walker.traverse((Object)this.graph, (Object)this.callback);
        ((TreeTraverseCallback)Mockito.verify((Object)this.callback)).startGraphTraversal((Graph)Matchers.eq((Object)this.graph));
        ((TreeTraverseCallback)Mockito.verify((Object)this.callback)).endGraphTraversal();
        ((TreeTraverseCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.atLeast((int)1))).startNodeTraversal((Node)this.nodeStartVisitCaptor.capture());
        ((TreeTraverseCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.atLeast((int)1))).endNodeTraversal((Node)this.nodeEndVisitCaptor.capture());
        ((TreeTraverseCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.atLeast((int)1))).startEdgeTraversal((Edge)this.edgeStartVisitCaptor.capture());
        ((TreeTraverseCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.atLeast((int)1))).endEdgeTraversal((Edge)this.edgeEndVisitCaptor.capture());
        Assert.assertEquals((long)3L, (long)this.nodeStartVisitCaptor.getAllValues().size());
        Assert.assertEquals((long)3L, (long)this.nodeEndVisitCaptor.getAllValues().size());
        this.assertNodeVisits(this.nodeStartVisitCaptor.getAllValues(), "node1", "node2", "node3");
        this.assertNodeVisits(this.nodeEndVisitCaptor.getAllValues(), "node1", "node2", "node3");
        Assert.assertEquals((long)2L, (long)this.edgeStartVisitCaptor.getAllValues().size());
        Assert.assertEquals((long)2L, (long)this.edgeEndVisitCaptor.getAllValues().size());
        this.assertEdgeVisits(this.edgeStartVisitCaptor.getAllValues(), "edge1:node1-node2", "edge2:node2-node3");
        this.assertEdgeVisits(this.edgeEndVisitCaptor.getAllValues(), "edge1:node1-node2", "edge2:node2-node3");
    }

    private void assertNodeVisits(List<Node> nodes, String ... expectedUUIDs) {
        List<String> actualUUIDs = nodes.stream().map(Element::getUUID).collect(Collectors.toList());
        this.assertVisits(Arrays.asList(expectedUUIDs), actualUUIDs);
    }

    private void assertEdgeVisits(List<Edge> edges, String ... expectedUUIDs) {
        List<String> actualUUIDs = edges.stream().map(Element::getUUID).collect(Collectors.toList());
        this.assertVisits(Arrays.asList(expectedUUIDs), actualUUIDs);
    }

    private void assertVisits(List<String> expectedUUIDs, List<String> actualUUIDs) {
        Assert.assertEquals((long)expectedUUIDs.size(), (long)actualUUIDs.size());
        ArrayList<String> matches = new ArrayList<String>(expectedUUIDs);
        matches.removeAll(actualUUIDs);
        Assert.assertTrue((boolean)matches.isEmpty());
    }

    private void connectNodes(Node source, Node target, Edge connector) {
        source.getOutEdges().add(connector);
        target.getInEdges().add(connector);
        connector.setSourceNode(source);
        connector.setTargetNode(target);
    }
}

