/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.adapter.binding;

import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertySetAdapterProxy;

import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFactory;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertySetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertySetAdapterProxy;

@Generated("org.kie.workbench.common.stunner.core.processors.propertyset.BindablePropertySetAdapterGenerator")
@ApplicationScoped
public class DMNDefinitionSetPropertySetAdapterImpl extends org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertySetAdapterProxy<Object> {

    private static final Map<Class, String> nameFieldNames = new HashMap<Class, String>(8) {{
            put( org.kie.workbench.common.dmn.api.definition.v1_1.Import.class, "propertySetName" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition.class, "propertySetName" );
            put( org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.class, "propertySetName" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.class, "propertySetName" );
            put( org.kie.workbench.common.dmn.api.property.font.FontSet.class, "propertySetName" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.class, "propertySetName" );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.class, "propertySetName" );
            put( org.kie.workbench.common.dmn.api.property.background.BackgroundSet.class, "propertySetName" );

    }};

    private static final Map<Class, Set<String>> propertiesFieldNames = new HashMap<Class, Set<String>>(8) {{
            put( org.kie.workbench.common.dmn.api.definition.v1_1.Import.class, new HashSet<String>() {{
                add ( "namespace" );
                add ( "locationURI" );
                add ( "importType" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition.class, new HashSet<String>() {{
                add ( "typeRef" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet.class, new HashSet<String>() {{
                add ( "width" );
                add ( "height" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression.class, new HashSet<String>() {{
                add ( "text" );
                add ( "expressionLanguage" );
                add ( "typeRef" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.property.font.FontSet.class, new HashSet<String>() {{
                add ( "fontFamily" );
                add ( "fontColour" );
                add ( "fontSize" );
                add ( "fontBorderSize" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.ImportedValues.class, new HashSet<String>() {{
                add ( "importedElement" );
                add ( "expressionLanguage" );
                add ( "namespace" );
                add ( "locationURI" );
                add ( "importType" );
            }} );
            put( org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem.class, new HashSet<String>() {{
                add ( "typeRef" );
                add ( "name" );
                add ( "id" );
                add ( "description" );
            }} );
            put( org.kie.workbench.common.dmn.api.property.background.BackgroundSet.class, new HashSet<String>() {{
                add ( "bgColour" );
                add ( "borderColour" );
                add ( "borderSize" );
            }} );
    }};

    protected DMNDefinitionSetPropertySetAdapterImpl() {
    }

    @Inject
    public DMNDefinitionSetPropertySetAdapterImpl(org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    protected void setBindings( final BindablePropertySetAdapter<Object> adapter ) {

        adapter.setBindings( nameFieldNames, propertiesFieldNames );

    }

}
