/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class InvocationTest {
    private Invocation invocation;

    @Before
    public void setup() {
        this.invocation = (Invocation)Mockito.spy((Object)new Invocation());
    }

    @Test
    public void testGetHasTypeRefs() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        Binding binding1 = (Binding)Mockito.mock(Binding.class);
        Binding binding2 = (Binding)Mockito.mock(Binding.class);
        List<Binding> binding = Arrays.asList(binding1, binding2);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((Invocation)Mockito.doReturn((Object)expression).when((Object)this.invocation)).getExpression();
        ((Invocation)Mockito.doReturn(binding).when((Object)this.invocation)).getBinding();
        PowerMockito.when((Object)expression.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        PowerMockito.when((Object)binding1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef3));
        PowerMockito.when((Object)binding2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef4));
        List actualHasTypeRefs = this.invocation.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.invocation, hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.invocation.getRequiredComponentWidthCount(), (long)this.invocation.getComponentWidths().size());
        this.invocation.getComponentWidths().forEach(Assert::assertNull);
    }
}

