/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DRGElementTest {
    private static final String[] READONLY_FIELDS = new String[]{"NameHolder", "AllowedAnswers", "Description", "Question", "DataType", "SourceType", "LocationURI"};
    @Mock
    private DRGElement drgElement;

    @Before
    public void setup() {
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).getReadOnly(Matchers.anyString());
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).setAllowOnlyVisualChange(Matchers.anyBoolean());
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).isAllowOnlyVisualChange();
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).isReadonlyField(Matchers.anyString());
    }

    @Test
    public void testGetReadOnlyNotSet() {
        this.drgElement.setAllowOnlyVisualChange(false);
        this.checkIfItIsNotSet("something");
    }

    @Test
    public void testGetReadOnlyWithReadOnlyValuesAndAllowOnlyVisualChangesNotSet() {
        this.drgElement.setAllowOnlyVisualChange(false);
        for (String readonlyField : READONLY_FIELDS) {
            this.checkIfItIsNotSet(readonlyField);
        }
    }

    private void checkIfItIsNotSet(String property) {
        DynamicReadOnly.ReadOnly actual = this.drgElement.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.NOT_SET, (Object)actual);
    }

    @Test
    public void testGetReadOnlyWithReadOnlyValues() {
        this.drgElement.setAllowOnlyVisualChange(true);
        for (String readonlyField : READONLY_FIELDS) {
            this.checkIfIsReadOnly(readonlyField);
        }
    }

    private void checkIfIsReadOnly(String property) {
        DynamicReadOnly.ReadOnly actual = this.drgElement.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.TRUE, (Object)actual);
    }

    @Test
    public void testGetReadOnlyWithNotReadOnlyValues() {
        this.drgElement.setAllowOnlyVisualChange(true);
        this.checkIfItIsNotReadOnly("Font");
        this.checkIfItIsNotReadOnly("Something");
    }

    private void checkIfItIsNotReadOnly(String property) {
        DynamicReadOnly.ReadOnly actual = this.drgElement.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.FALSE, (Object)actual);
    }
}

