/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.RuleAnnotationClause;
import org.kie.workbench.common.dmn.api.definition.model.common.HasTypeRefHelper;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
public class DecisionTable
extends Expression {
    private static final int STATIC_COLUMNS = 1;
    private List<InputClause> input;
    private List<OutputClause> output;
    private List<DecisionRule> rule;
    private HitPolicy hitPolicy;
    private BuiltinAggregator aggregation;
    private DecisionTableOrientation preferredOrientation;
    private String outputLabel;
    private List<RuleAnnotationClause> annotations;

    public DecisionTable() {
        this(new Id(), new Description(), new QName(), null, null, null, HitPolicy.UNIQUE, null, DecisionTableOrientation.RULE_AS_ROW, null);
    }

    public DecisionTable(Id id, Description description, QName typeRef, List<InputClause> input, List<OutputClause> output, List<DecisionRule> rule, HitPolicy hitPolicy, BuiltinAggregator aggregation, DecisionTableOrientation preferredOrientation, String outputLabel) {
        super(id, description, typeRef);
        this.input = input;
        this.output = output;
        this.rule = rule;
        this.hitPolicy = hitPolicy;
        this.aggregation = aggregation;
        this.preferredOrientation = preferredOrientation;
        this.outputLabel = outputLabel;
    }

    public List<RuleAnnotationClause> getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<RuleAnnotationClause>();
        }
        return this.annotations;
    }

    public List<InputClause> getInput() {
        if (this.input == null) {
            this.input = new ArrayList<InputClause>();
        }
        return this.input;
    }

    public List<OutputClause> getOutput() {
        if (this.output == null) {
            this.output = new ArrayList<OutputClause>();
        }
        return this.output;
    }

    public List<DecisionRule> getRule() {
        if (this.rule == null) {
            this.rule = new ArrayList<DecisionRule>();
        }
        return this.rule;
    }

    public HitPolicy getHitPolicy() {
        if (this.hitPolicy == null) {
            return HitPolicy.UNIQUE;
        }
        return this.hitPolicy;
    }

    public void setHitPolicy(HitPolicy value) {
        this.hitPolicy = value;
    }

    public BuiltinAggregator getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(BuiltinAggregator value) {
        this.aggregation = value;
    }

    public DecisionTableOrientation getPreferredOrientation() {
        if (this.preferredOrientation == null) {
            return DecisionTableOrientation.RULE_AS_ROW;
        }
        return this.preferredOrientation;
    }

    public void setPreferredOrientation(DecisionTableOrientation value) {
        this.preferredOrientation = value;
    }

    public String getOutputLabel() {
        return this.outputLabel;
    }

    public void setOutputLabel(String value) {
        this.outputLabel = value;
    }

    @Override
    public List<HasTypeRef> getHasTypeRefs() {
        List<HasTypeRef> hasTypeRefs = super.getHasTypeRefs();
        hasTypeRefs.addAll(HasTypeRefHelper.getFlatHasTypeRefs(this.getInput()));
        hasTypeRefs.addAll(HasTypeRefHelper.getFlatHasTypeRefs(this.getOutput()));
        hasTypeRefs.addAll(HasTypeRefHelper.getFlatHasTypeRefs(this.getRule()));
        return hasTypeRefs;
    }

    @Override
    public int getRequiredComponentWidthCount() {
        return this.getInput().size() + this.getOutput().size() + this.getAnnotations().size() + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecisionTable)) {
            return false;
        }
        DecisionTable that = (DecisionTable)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.typeRef != null ? !this.typeRef.equals(that.typeRef) : that.typeRef != null) {
            return false;
        }
        if (this.componentWidths != null ? !this.componentWidths.equals(that.componentWidths) : that.componentWidths != null) {
            return false;
        }
        if (this.input != null ? !this.input.equals(that.input) : that.input != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.rule != null ? !this.rule.equals(that.rule) : that.rule != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.hitPolicy != that.hitPolicy) {
            return false;
        }
        if (this.aggregation != that.aggregation) {
            return false;
        }
        if (this.preferredOrientation != that.preferredOrientation) {
            return false;
        }
        return this.outputLabel != null ? this.outputLabel.equals(that.outputLabel) : that.outputLabel == null;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.id != null ? this.id.hashCode() : 0, this.description != null ? this.description.hashCode() : 0, this.typeRef != null ? this.typeRef.hashCode() : 0, this.componentWidths != null ? this.componentWidths.hashCode() : 0, this.input != null ? this.input.hashCode() : 0, this.output != null ? this.output.hashCode() : 0, this.rule != null ? this.rule.hashCode() : 0, this.hitPolicy != null ? this.hitPolicy.hashCode() : 0, this.aggregation != null ? this.aggregation.hashCode() : 0, this.preferredOrientation != null ? this.preferredOrientation.hashCode() : 0, this.outputLabel != null ? this.outputLabel.hashCode() : 0, this.annotations != null ? this.annotations.hashCode() : 0});
    }
}

