/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextTest {
    private Context context;

    @Before
    public void setup() {
        this.context = (Context)Mockito.spy((Object)new Context());
    }

    @Test
    public void testGetHasTypeRefs() {
        ContextEntry contextEntry1 = (ContextEntry)Mockito.mock(ContextEntry.class);
        ContextEntry contextEntry2 = (ContextEntry)Mockito.mock(ContextEntry.class);
        List<ContextEntry> contextEntry = Arrays.asList(contextEntry1, contextEntry2);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((Context)Mockito.doReturn(contextEntry).when((Object)this.context)).getContextEntry();
        PowerMockito.when((Object)contextEntry1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1));
        PowerMockito.when((Object)contextEntry2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef2));
        List actualHasTypeRefs = this.context.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.context, hasTypeRef1, hasTypeRef2);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.context.getRequiredComponentWidthCount(), (long)this.context.getComponentWidths().size());
        this.context.getComponentWidths().forEach(Assert::assertNull);
    }
}

