/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.editors.included;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;

public class DMNImportTypesTest {
    @Test
    public void testDMN() {
        Assert.assertEquals((Object)"dmn", (Object)DMNImportTypes.DMN.getFileExtension());
        Assert.assertEquals((Object)DMNImportTypes.DMN, (Object)DMNImportTypes.determineImportType((String)"http://www.omg.org/spec/DMN/20180521/MODEL/"));
    }

    @Test
    public void testPMML() {
        Assert.assertEquals((Object)"pmml", (Object)DMNImportTypes.PMML.getFileExtension());
        Assert.assertEquals((Object)DMNImportTypes.PMML, (Object)DMNImportTypes.determineImportType((String)"http://www.dmg.org/PMML-3_0"));
        Assert.assertEquals((Object)DMNImportTypes.PMML, (Object)DMNImportTypes.determineImportType((String)"http://www.dmg.org/PMML-3_1"));
        Assert.assertEquals((Object)DMNImportTypes.PMML, (Object)DMNImportTypes.determineImportType((String)"http://www.dmg.org/PMML-3_2"));
        Assert.assertEquals((Object)DMNImportTypes.PMML, (Object)DMNImportTypes.determineImportType((String)"http://www.dmg.org/PMML-4_0"));
        Assert.assertEquals((Object)DMNImportTypes.PMML, (Object)DMNImportTypes.determineImportType((String)"http://www.dmg.org/PMML-4_1"));
        Assert.assertEquals((Object)DMNImportTypes.PMML, (Object)DMNImportTypes.determineImportType((String)"http://www.dmg.org/PMML-4_2"));
        Assert.assertEquals((Object)DMNImportTypes.PMML, (Object)DMNImportTypes.determineImportType((String)"http://www.dmg.org/PMML-4_3"));
    }

    @Test
    public void testUnknown() {
        Assert.assertNull((Object)DMNImportTypes.determineImportType((String)"cheese"));
    }

    @Test
    public void testGetNamespacesDMN() {
        List namespaces = DMNImportTypes.DMN.getNamespaces();
        Assert.assertEquals((long)1L, (long)namespaces.size());
        Assert.assertEquals((Object)"http://www.omg.org/spec/DMN/20180521/MODEL/", namespaces.get(0));
    }

    @Test
    public void testGetNamespacesPMML() {
        List namespaces = DMNImportTypes.PMML.getNamespaces();
        Assert.assertEquals((long)7L, (long)namespaces.size());
        Assert.assertEquals((Object)"http://www.dmg.org/PMML-3_0", namespaces.get(0));
        Assert.assertEquals((Object)"http://www.dmg.org/PMML-3_1", namespaces.get(1));
        Assert.assertEquals((Object)"http://www.dmg.org/PMML-3_2", namespaces.get(2));
        Assert.assertEquals((Object)"http://www.dmg.org/PMML-4_0", namespaces.get(3));
        Assert.assertEquals((Object)"http://www.dmg.org/PMML-4_1", namespaces.get(4));
        Assert.assertEquals((Object)"http://www.dmg.org/PMML-4_2", namespaces.get(5));
        Assert.assertEquals((Object)"http://www.dmg.org/PMML-4_3", namespaces.get(6));
    }

    @Test
    public void testGetDefaultNameSpaceDMN() {
        Assert.assertEquals((Object)"http://www.omg.org/spec/DMN/20180521/MODEL/", (Object)DMNImportTypes.DMN.getDefaultNamespace());
    }

    @Test
    public void testGetDefaultNameSpacePMML() {
        Assert.assertEquals((Object)"http://www.dmg.org/PMML-4_3", (Object)DMNImportTypes.PMML.getDefaultNamespace());
    }
}

