/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.editors.types;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;

public class BuiltInTypeUtilsTest {
    @Test
    public void testIsDefaultWhenTypeIsDefault() {
        Assert.assertTrue((boolean)BuiltInTypeUtils.isBuiltInType((String)"string"));
    }

    @Test
    public void testIsDefaultWhenTypeIsDefaultWithAlternativeAlias() {
        Assert.assertTrue((boolean)BuiltInTypeUtils.isBuiltInType((String)"dayTimeDuration"));
    }

    @Test
    public void testIsNotDefaultWhenTypeIsDefaultWithAnUpperCaseCharacter() {
        Assert.assertFalse((boolean)BuiltInTypeUtils.isBuiltInType((String)"String"));
    }

    @Test
    public void testIsDefaultWhenTypeIsNull() {
        Assert.assertFalse((boolean)BuiltInTypeUtils.isBuiltInType(null));
    }

    @Test
    public void testIsDefaultWhenTypeIsNotDefault() {
        Assert.assertFalse((boolean)BuiltInTypeUtils.isBuiltInType((String)"tAddress"));
    }

    @Test
    public void testFindBuiltInTypeByNameWhenItFinds() {
        Assert.assertTrue((boolean)BuiltInTypeUtils.findBuiltInTypeByName((String)"boolean").isPresent());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN, BuiltInTypeUtils.findBuiltInTypeByName((String)"boolean").get());
    }

    @Test
    public void testFindBuiltInTypeByNameWhenItDoesNotFind() {
        Assert.assertFalse((boolean)BuiltInTypeUtils.findBuiltInTypeByName((String)"something").isPresent());
    }
}

