/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;

public class InputClauseLiteralExpressionTest {
    private static final String CLAUSE_ID = "CLAUSE_ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String TEXT = "TEXT";
    private InputClauseLiteralExpression inputClauseLiteralExpression;

    @Before
    public void setup() {
        this.inputClauseLiteralExpression = new InputClauseLiteralExpression();
    }

    @Test
    public void testGetHasTypeRefs() {
        List actualHasTypeRefs = this.inputClauseLiteralExpression.getHasTypeRefs();
        List<InputClauseLiteralExpression> expectedHasTypeRefs = Collections.singletonList(this.inputClauseLiteralExpression);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testCopy() {
        InputClauseLiteralExpression source = new InputClauseLiteralExpression(new Id(CLAUSE_ID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new Text(TEXT), new ImportedValues());
        InputClauseLiteralExpression target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)CLAUSE_ID, (Object)target.getId());
        Assert.assertEquals((Object)TEXT, (Object)target.getText().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getTypeRef());
    }
}

