/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextEntryTest {
    private static final String ITEM_ID = "item-id";
    private static final String DESCRIPTION = "description";
    private static final String INFORMATION_ITEM_NAME = "item-name";
    private ContextEntry contextEntry;

    @Before
    public void setup() {
        this.contextEntry = (ContextEntry)Mockito.spy((Object)new ContextEntry());
    }

    @Test
    public void testGetHasTypeRefs() {
        Expression expression = (Expression)Mockito.mock(Expression.class);
        InformationItem variable = (InformationItem)Mockito.mock(InformationItem.class);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((ContextEntry)Mockito.doReturn((Object)expression).when((Object)this.contextEntry)).getExpression();
        ((ContextEntry)Mockito.doReturn((Object)variable).when((Object)this.contextEntry)).getVariable();
        PowerMockito.when((Object)expression.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        PowerMockito.when((Object)variable.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef3, hasTypeRef4));
        List actualHasTypeRefs = this.contextEntry.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testCopy() {
        ContextEntry source = new ContextEntry();
        InformationItem informationItem = new InformationItem(new Id(ITEM_ID), new Description(DESCRIPTION), new Name(INFORMATION_ITEM_NAME), BuiltInType.BOOLEAN.asQName());
        source.setVariable(informationItem);
        ContextEntry target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNull((Object)target.getExpression());
        Assert.assertNotNull((Object)target.getVariable());
        Assert.assertNotEquals((Object)ITEM_ID, (Object)target.getVariable().getId().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getVariable().getDescription().getValue());
        Assert.assertEquals((Object)INFORMATION_ITEM_NAME, (Object)target.getVariable().getName().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getVariable().getTypeRef());
    }
}

