/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionTableTest {
    private static final String TABLE_ID = "TABLE-ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String OUTPUT_LABEL = "OUTPUT-LABEL";
    private DecisionTable decisionTable;

    @Before
    public void setup() {
        this.decisionTable = (DecisionTable)Mockito.spy((Object)new DecisionTable());
    }

    @Test
    public void testDefaultHitPolicy() {
        Assert.assertEquals((Object)HitPolicy.UNIQUE, (Object)this.decisionTable.getHitPolicy());
    }

    @Test
    public void testGetHasTypeRefs() {
        InputClause inputClauses1 = (InputClause)Mockito.mock(InputClause.class);
        InputClause inputClauses2 = (InputClause)Mockito.mock(InputClause.class);
        List<InputClause> inputClauses = Arrays.asList(inputClauses1, inputClauses2);
        OutputClause outputClauses1 = (OutputClause)Mockito.mock(OutputClause.class);
        OutputClause outputClauses2 = (OutputClause)Mockito.mock(OutputClause.class);
        List<OutputClause> outputClauses = Arrays.asList(outputClauses1, outputClauses2);
        DecisionRule decisionRules1 = (DecisionRule)Mockito.mock(DecisionRule.class);
        DecisionRule decisionRules2 = (DecisionRule)Mockito.mock(DecisionRule.class);
        List<DecisionRule> decisionRules = Arrays.asList(decisionRules1, decisionRules2);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef5 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef6 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((DecisionTable)Mockito.doReturn(inputClauses).when((Object)this.decisionTable)).getInput();
        ((DecisionTable)Mockito.doReturn(outputClauses).when((Object)this.decisionTable)).getOutput();
        ((DecisionTable)Mockito.doReturn(decisionRules).when((Object)this.decisionTable)).getRule();
        PowerMockito.when((Object)inputClauses1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1));
        PowerMockito.when((Object)inputClauses2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef2));
        PowerMockito.when((Object)outputClauses1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef3));
        PowerMockito.when((Object)outputClauses2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef4));
        PowerMockito.when((Object)decisionRules1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef5));
        PowerMockito.when((Object)decisionRules2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef6));
        List actualHasTypeRefs = this.decisionTable.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.decisionTable, hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4, hasTypeRef5, hasTypeRef6);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.decisionTable.getRequiredComponentWidthCount(), (long)this.decisionTable.getComponentWidths().size());
        this.decisionTable.getComponentWidths().forEach(Assert::assertNull);
    }

    @Test
    public void testCopy() {
        DecisionTable source = new DecisionTable(new Id(TABLE_ID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new ArrayList(), new ArrayList(), new ArrayList(), HitPolicy.UNIQUE, BuiltinAggregator.SUM, DecisionTableOrientation.RULE_AS_ROW, OUTPUT_LABEL);
        DecisionTable target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)TABLE_ID, (Object)target.getId().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getTypeRef());
        Assert.assertTrue((boolean)target.getInput().isEmpty());
        Assert.assertTrue((boolean)target.getOutput().isEmpty());
        Assert.assertTrue((boolean)target.getRule().isEmpty());
        Assert.assertEquals((Object)HitPolicy.UNIQUE, (Object)target.getHitPolicy());
        Assert.assertEquals((Object)BuiltinAggregator.SUM, (Object)target.getAggregation());
        Assert.assertEquals((Object)DecisionTableOrientation.RULE_AS_ROW, (Object)target.getPreferredOrientation());
        Assert.assertEquals((Object)OUTPUT_LABEL, (Object)target.getOutputLabel());
    }
}

