/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.QNameHolder;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;

public class InformationItemTest {
    private static final String ITEM_ID = "ITEM_ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String INFORMATION_ITEM_NAME = "INFORMATION_ITEM_NAME";
    private InformationItem informationItem;

    @Before
    public void setup() {
        this.informationItem = new InformationItem();
    }

    @Test
    public void testTypeRefHolderWrapsTypeRef() {
        QName typeRef = this.informationItem.getTypeRef();
        QNameHolder typeRefHolder = this.informationItem.getTypeRefHolder();
        Assert.assertEquals((Object)typeRef, (Object)typeRefHolder.getValue());
    }

    @Test
    public void testTypeRefHolderWrapsTypeRefAfterSettingTypeRef() {
        QName typeRef = new QName();
        this.informationItem.setTypeRef(typeRef);
        Assert.assertEquals((Object)typeRef, (Object)this.informationItem.getTypeRef());
        QNameHolder typeRefHolder = this.informationItem.getTypeRefHolder();
        Assert.assertEquals((Object)typeRef, (Object)typeRefHolder.getValue());
    }

    @Test
    public void testTypeRefHolderWrapsTYpeRefAfterSettingTypeRefHolder() {
        QName typeRef = this.informationItem.getTypeRef();
        this.informationItem.setTypeRefHolder(new QNameHolder());
        Assert.assertEquals((Object)typeRef, (Object)this.informationItem.getTypeRefHolder().getValue());
    }

    @Test
    public void testGetHasTypeRefs() {
        List actualHasTypeRefs = this.informationItem.getHasTypeRefs();
        List<InformationItem> expectedHasTypeRefs = Collections.singletonList(this.informationItem);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testCopy() {
        InformationItem source = new InformationItem(new Id(ITEM_ID), new Description(DESCRIPTION), new Name(INFORMATION_ITEM_NAME), BuiltInType.BOOLEAN.asQName());
        InformationItem target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)ITEM_ID, (Object)target.getId().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertEquals((Object)INFORMATION_ITEM_NAME, (Object)target.getName().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getTypeRef());
    }
}

