/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class OutputClauseTest {
    private static final String OUTPUT_ID = "OUTPUT-ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String NAME = "NAME";
    private static final String TEXT = "TEXT";
    private static final String CLAUSE_ID = "CLAUSE_ID";
    private static final String UNARY_ID = "UNARY_ID";
    private OutputClause outputClause;

    @Before
    public void setup() {
        this.outputClause = (OutputClause)Mockito.spy((Object)new OutputClause());
    }

    @Test
    public void testGetHasTypeRefs() {
        OutputClauseLiteralExpression outputClauseLiteralExpression = (OutputClauseLiteralExpression)Mockito.mock(OutputClauseLiteralExpression.class);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((OutputClause)Mockito.doReturn((Object)outputClauseLiteralExpression).when((Object)this.outputClause)).getDefaultOutputEntry();
        PowerMockito.when((Object)outputClauseLiteralExpression.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        List actualHasTypeRefs = this.outputClause.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.outputClause, hasTypeRef1, hasTypeRef2);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testCopy() {
        OutputClause source = new OutputClause(new Id(OUTPUT_ID), new Description(DESCRIPTION), this.buildOutputClauseUnaryTests(), this.buildOutputClauseLiteralExpression(), NAME, BuiltInType.BOOLEAN.asQName());
        OutputClause target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)OUTPUT_ID, (Object)target.getId().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertNotNull((Object)target.getOutputValues());
        Assert.assertNotEquals((Object)CLAUSE_ID, (Object)target.getOutputValues().getId());
        Assert.assertEquals((Object)TEXT, (Object)target.getOutputValues().getText().getValue());
        Assert.assertNotNull((Object)target.getOutputValues());
        Assert.assertNotEquals((Object)UNARY_ID, (Object)target.getOutputValues().getId());
        Assert.assertEquals((Object)TEXT, (Object)target.getOutputValues().getText().getValue());
        Assert.assertEquals((Object)ConstraintType.ENUMERATION, (Object)target.getOutputValues().getConstraintType());
    }

    private OutputClauseUnaryTests buildOutputClauseUnaryTests() {
        return new OutputClauseUnaryTests(new Id(UNARY_ID), new Text(TEXT), ConstraintType.ENUMERATION);
    }

    private OutputClauseLiteralExpression buildOutputClauseLiteralExpression() {
        return new OutputClauseLiteralExpression(new Id(CLAUSE_ID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new Text(TEXT), new ImportedValues());
    }
}

