/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LiteralExpressionTest {
    private static final String LITERAL_ID = "LITERAL-ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String TEXT = "TEXT";
    private static final String EXPRESSION_LANGUAGE = "EXPRESSION-LANGUAGE";
    private LiteralExpression literalExpression;

    @Before
    public void setup() {
        this.literalExpression = new LiteralExpression();
    }

    @Test
    public void testGetHasTypeRefs() {
        List actualHasTypeRefs = this.literalExpression.getHasTypeRefs();
        List<LiteralExpression> expectedHasTypeRefs = Collections.singletonList(this.literalExpression);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.literalExpression.getRequiredComponentWidthCount(), (long)this.literalExpression.getComponentWidths().size());
        this.literalExpression.getComponentWidths().forEach(Assert::assertNull);
    }

    @Test
    public void testCopy() {
        LiteralExpression source = new LiteralExpression(new Id(LITERAL_ID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new Text(TEXT), null, new ExpressionLanguage(EXPRESSION_LANGUAGE));
        LiteralExpression target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)LITERAL_ID, (Object)target.getId());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getTypeRef());
        Assert.assertEquals((Object)TEXT, (Object)target.getText().getValue());
        Assert.assertNull((Object)target.getImportedValues());
        Assert.assertEquals((Object)EXPRESSION_LANGUAGE, (Object)target.getExpressionLanguage().getValue());
    }
}

