/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class ListTest {
    private static final String LIST_ID = "LIST_ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private List list;

    @Before
    public void setup() {
        this.list = (List)Mockito.spy((Object)new List());
    }

    @Test
    public void testGetHasTypeRefs() {
        Expression expression1 = (Expression)Mockito.mock(Expression.class);
        Expression expression2 = (Expression)Mockito.mock(Expression.class);
        java.util.List<HasExpression> hasExpressions = Arrays.asList(HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)expression1), HasExpression.wrap((DMNModelInstrumentedBase)this.list, (Expression)expression2));
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((List)Mockito.doReturn(hasExpressions).when((Object)this.list)).getExpression();
        PowerMockito.when((Object)expression1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1));
        PowerMockito.when((Object)expression2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef2));
        java.util.List actualHasTypeRefs = this.list.getHasTypeRefs();
        java.util.List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.list, hasTypeRef1, hasTypeRef2);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.list.getRequiredComponentWidthCount(), (long)this.list.getComponentWidths().size());
        this.list.getComponentWidths().forEach(Assert::assertNull);
    }

    @Test
    public void testCopy() {
        List source = new List(new Id(LIST_ID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new ArrayList());
        List target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)LIST_ID, (Object)target.getId());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getTypeRef());
        Assert.assertTrue((boolean)target.getExpression().isEmpty());
    }
}

