/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class DRGElementTest {
    private static final String[] READONLY_FIELDS = new String[]{"NameHolder", "AllowedAnswers", "Description", "Question", "DataType", "SourceType", "LocationURI"};
    @Mock
    private DRGElement drgElement;

    @Before
    public void setup() {
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).getReadOnly(Matchers.anyString());
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).setAllowOnlyVisualChange(Matchers.anyBoolean());
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).isAllowOnlyVisualChange();
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).isReadonlyField(Matchers.anyString());
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).getContentDefinitionId();
        ((DRGElement)Mockito.doCallRealMethod().when((Object)this.drgElement)).getStringName();
    }

    @Test
    public void testGetReadOnlyNotSet() {
        this.drgElement.setAllowOnlyVisualChange(false);
        this.checkIfItIsNotSet("something");
    }

    @Test
    public void testGetReadOnlyWithReadOnlyValuesAndAllowOnlyVisualChangesNotSet() {
        this.drgElement.setAllowOnlyVisualChange(false);
        for (String readonlyField : READONLY_FIELDS) {
            this.checkIfItIsNotSet(readonlyField);
        }
    }

    private void checkIfItIsNotSet(String property) {
        DynamicReadOnly.ReadOnly actual = this.drgElement.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.NOT_SET, (Object)actual);
    }

    @Test
    public void testGetReadOnlyWithReadOnlyValues() {
        this.drgElement.setAllowOnlyVisualChange(true);
        for (String readonlyField : READONLY_FIELDS) {
            this.checkIfIsReadOnly(readonlyField);
        }
    }

    private void checkIfIsReadOnly(String property) {
        DynamicReadOnly.ReadOnly actual = this.drgElement.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.TRUE, (Object)actual);
    }

    @Test
    public void testGetReadOnlyWithNotReadOnlyValues() {
        this.drgElement.setAllowOnlyVisualChange(true);
        this.checkIfItIsNotReadOnly("Font");
        this.checkIfItIsNotReadOnly("Something");
    }

    @Test
    public void testGetContentDefinitionId() {
        String contentDefinitionId = "the id";
        Id id = (Id)PowerMockito.mock(Id.class);
        Mockito.when((Object)this.drgElement.getId()).thenReturn((Object)id);
        Mockito.when((Object)id.getValue()).thenReturn((Object)"the id");
        String currentId = this.drgElement.getContentDefinitionId();
        Assert.assertEquals((Object)"the id", (Object)currentId);
    }

    @Test
    public void testGetStringName() {
        Name name = (Name)PowerMockito.mock(Name.class);
        String theName = "the name";
        Mockito.when((Object)name.getValue()).thenReturn((Object)"the name");
        ((DRGElement)Mockito.doReturn((Object)name).when((Object)this.drgElement)).getName();
        String stringName = this.drgElement.getStringName();
        Assert.assertEquals((Object)"the name", (Object)stringName);
    }

    private void checkIfItIsNotReadOnly(String property) {
        DynamicReadOnly.ReadOnly actual = this.drgElement.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.FALSE, (Object)actual);
    }
}

