/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.factory;

import java.util.function.Function;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.impl.BindableDiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public abstract class AbstractDMNDiagramFactory<M extends Metadata, D extends Diagram<Graph, M>>
extends BindableDiagramFactory<M, D> {
    private static final Class<DMNDiagram> DIAGRAM_TYPE = DMNDiagram.class;
    private Function<Graph, Node<Definition<DMNDiagram>, ?>> diagramProvider = graph -> GraphUtils.getFirstNode((Graph)graph, DIAGRAM_TYPE);

    protected abstract D doBuild(String var1, M var2, Graph<DefinitionSet, ?> var3);

    public D build(String name, M metadata, Graph<DefinitionSet, ?> graph) {
        D diagram = this.doBuild(name, metadata, graph);
        Node<Definition<DMNDiagram>, ?> diagramNode = this.diagramProvider.apply(graph);
        if (null == diagramNode) {
            throw new IllegalStateException("A BPMN Diagram is expected to be present on BPMN Diagram graphs.");
        }
        this.updateProperties(diagramNode, metadata);
        return diagram;
    }

    private void updateProperties(Node<Definition<DMNDiagram>, ?> diagramNode, M metadata) {
        metadata.setCanvasRootUUID(diagramNode.getUUID());
    }
}

