/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.factory;

import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import java.util.LinkedHashSet;
import java.util.Set;

@Generated("org.kie.workbench.common.stunner.core.processors.factory.ModelFactoryGenerator")
@ApplicationScoped
public class DMNDefinitionSetModelFactoryImpl extends org.kie.workbench.common.stunner.core.factory.definition.AbstractTypeDefinitionFactory<Object> {

    private static final Set<Class<?>> SUPPORTED_DEF_CLASSES = new LinkedHashSet<Class<?>>() {{

            add( org.kie.workbench.common.dmn.api.definition.model.TextAnnotation.class );
            add( org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression.class );
            add( org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel.class );
            add( org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.class );
            add( org.kie.workbench.common.dmn.api.definition.model.ImportedValues.class );
            add( org.kie.workbench.common.dmn.api.definition.NOPDomainObject.class );
            add( org.kie.workbench.common.dmn.api.definition.model.OutputClause.class );
            add( org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression.class );
            add( org.kie.workbench.common.dmn.api.definition.model.DMNDiagram.class );
            add( org.kie.workbench.common.dmn.api.definition.model.InputData.class );
            add( org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.class );
            add( org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument.class );
            add( org.kie.workbench.common.dmn.api.definition.model.Association.class );
            add( org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.model.UnaryTests.class );
            add( org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel.class );
            add( org.kie.workbench.common.dmn.api.definition.model.DecisionService.class );
            add( org.kie.workbench.common.dmn.api.definition.model.InformationItem.class );
            add( org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource.class );
            add( org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.model.Decision.class );
            add( org.kie.workbench.common.dmn.api.definition.model.InformationRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.model.InputClause.class );
            add( org.kie.workbench.common.dmn.api.DMNDefinitionSet.class );

    }};

    public DMNDefinitionSetModelFactoryImpl() {
    }

    @Override
    public Set<Class<?>> getAcceptedClasses() {
        return SUPPORTED_DEF_CLASSES;
    }

    @Override
    public Object build( final Class<?> clazz ) {


            if ( org.kie.workbench.common.dmn.api.definition.model.TextAnnotation.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.TextAnnotation();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.LiteralExpression();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.ImportedValues.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.ImportedValues();

            }


            if ( org.kie.workbench.common.dmn.api.definition.NOPDomainObject.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.NOPDomainObject();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.OutputClause.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.OutputClause();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.DMNDiagram.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.DMNDiagram();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.InputData.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.InputData();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.Association.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.Association();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement.AuthorityRequirementBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.UnaryTests.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.UnaryTests();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.DecisionService.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.DecisionService();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.InformationItem.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.InformationItem();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.Decision.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.Decision();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.InformationRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.InformationRequirement();

            }


            if ( org.kie.workbench.common.dmn.api.definition.model.InputClause.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.model.InputClause();

            }


            if ( org.kie.workbench.common.dmn.api.DMNDefinitionSet.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.DMNDefinitionSet.DMNDefinitionSetBuilder().build();

            }


        throw new RuntimeException( "This factory [" + this.getClass().getName() + "] " +
            "should provide a definition for [" + clazz + "]" );
    }

}
