/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class RelationTest {
    private static final String RELATION_ID = "RELATION-ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private Relation relation;

    @Before
    public void setup() {
        this.relation = (Relation)Mockito.spy((Object)new Relation());
    }

    @Test
    public void testGetHasTypeRefs() {
        InformationItem column1 = (InformationItem)Mockito.mock(InformationItem.class);
        InformationItem column2 = (InformationItem)Mockito.mock(InformationItem.class);
        java.util.List<InformationItem> column = Arrays.asList(column1, column2);
        List row1 = (List)Mockito.mock(List.class);
        List row2 = (List)Mockito.mock(List.class);
        java.util.List<List> row = Arrays.asList(row1, row2);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((Relation)Mockito.doReturn(column).when((Object)this.relation)).getColumn();
        ((Relation)Mockito.doReturn(row).when((Object)this.relation)).getRow();
        PowerMockito.when((Object)column1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1));
        PowerMockito.when((Object)column2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef2));
        PowerMockito.when((Object)row1.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef3));
        PowerMockito.when((Object)row2.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef4));
        java.util.List actualHasTypeRefs = this.relation.getHasTypeRefs();
        java.util.List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(this.relation, hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testComponentWidths() {
        Assert.assertEquals((long)this.relation.getRequiredComponentWidthCount(), (long)this.relation.getComponentWidths().size());
        this.relation.getComponentWidths().forEach(Assert::assertNull);
    }

    @Test
    public void testCopy() {
        Relation source = new Relation(new Id(RELATION_ID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new ArrayList(), new ArrayList());
        Relation target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)RELATION_ID, (Object)target.getId());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getTypeRef());
        Assert.assertTrue((boolean)target.getColumn().isEmpty());
        Assert.assertTrue((boolean)target.getRow().isEmpty());
    }
}

