/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.factory;

import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import java.util.LinkedHashSet;
import java.util.Set;

@Generated("org.kie.workbench.common.stunner.core.processors.factory.ModelFactoryGenerator")
@ApplicationScoped
public class DMNDefinitionSetModelFactoryImpl extends org.kie.workbench.common.stunner.core.factory.definition.AbstractTypeDefinitionFactory<Object> {

    private static final Set<Class<?>> SUPPORTED_DEF_CLASSES = new LinkedHashSet<Class<?>>() {{

            add( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class );
            add( org.kie.workbench.common.dmn.api.definition.v1_1.Association.class );
            add( org.kie.workbench.common.dmn.api.DMNDefinitionSet.class );

    }};

    public DMNDefinitionSetModelFactoryImpl() {
    }

    @Override
    public Set<Class<?>> getAcceptedClasses() {
        return SUPPORTED_DEF_CLASSES;
    }

    @Override
    public Object build( final Class<?> clazz ) {


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel.BusinessKnowledgeModelBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation.TextAnnotationBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement.AuthorityRequirementBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.InputData.InputDataBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram.DMNDiagramBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource.KnowledgeSourceBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement.KnowledgeRequirementBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.InformationRequirementBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.Decision.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.Decision.DecisionBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.definition.v1_1.Association.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.definition.v1_1.Association.AssociationBuilder().build();

            }


            if ( org.kie.workbench.common.dmn.api.DMNDefinitionSet.class.equals( clazz ) ) {

                return new org.kie.workbench.common.dmn.api.DMNDefinitionSet.DMNDefinitionSetBuilder().build();

            }


        throw new RuntimeException( "This factory [" + this.getClass().getName() + "] " +
            "should provide a definition for [" + clazz + "]" );
    }

}
