/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.adapter.binding;

import java.util.HashMap;
import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapterWrapper;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFunctions;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertyAdapterImpl;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

@Generated("org.kie.workbench.common.stunner.core.processors.property.BindablePropertyAdapterGenerator")
@ApplicationScoped
public class DMNDefinitionSetPropertyAdapterImpl extends PropertyAdapterWrapper<Object, Object, BindablePropertyAdapter<Object, Object>> {

    @Inject
    public DMNDefinitionSetPropertyAdapterImpl(StunnerTranslationService translationService,
                            BindableAdapterFunctions functions) {
        super(BindablePropertyAdapterImpl.create(translationService, functions, new HashMap<>(23)));
    }

    @PostConstruct
    public void init() {
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.Question.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dimensions.Height.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dimensions.Width.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.NameHolder.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.background.BorderSize.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.ConstraintTypeProperty.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.LocationURI.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.font.FontFamily.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.TextFormat.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.background.BorderColour.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.Id.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.Text.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListHolder.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.Description.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.font.FontSize.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.font.FontColour.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers.class, "value");
            adapter.addBinding(org.kie.workbench.common.dmn.api.property.background.BgColour.class, "value");
    }

}
