/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.adapter.binding;

import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import org.kie.workbench.common.stunner.core.definition.adapter.HasInheritance;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFunctions;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapterWrapper;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapterImpl;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.DefinitionAdapterBindings;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

@Generated("org.kie.workbench.common.stunner.core.processors.definition.BindableDefinitionAdapterGenerator")
@ApplicationScoped
public class DMNDefinitionSetDefinitionAdapterImpl extends DefinitionAdapterWrapper<Object, BindableDefinitionAdapter<Object>> implements HasInheritance {

    protected DMNDefinitionSetDefinitionAdapterImpl() {
    }

    @Inject
    public DMNDefinitionSetDefinitionAdapterImpl(StunnerTranslationService translationService, BindableAdapterFunctions functions) {
        super(BindableDefinitionAdapterImpl.create(translationService, functions, new HashMap<>(23)));
    }

    @PostConstruct
    public void init() {
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.TextAnnotation.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("text","textFormat","stylingSet.bgColour","stylingSet.borderColour","stylingSet.fontFamily","stylingSet.fontColour","stylingSet.fontSize","dimensionsSet.width","dimensionsSet.height","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true,true,true,true,true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("0,7,8,-1,9")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("typeRefHolder","text")).setTypedPropertyFields(Arrays.asList(true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("variable.typeRefHolder","stylingSet.bgColour","stylingSet.borderColour","stylingSet.fontFamily","stylingSet.fontColour","stylingSet.fontSize","dimensionsSet.width","dimensionsSet.height","linksHolder","nameHolder","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true,true,true,true,true,true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("9,6,7,-1,10")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("expressionLanguage","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.ImportedValues.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("expressionLanguage","nameHolder","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("1,-1,-1,-1,2")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.NOPDomainObject.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList()).setTypedPropertyFields(Arrays.asList()).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("text")).setTypedPropertyFields(Arrays.asList(true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.OutputClause.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("outputValues.text","defaultOutputEntry.text","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,2")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.DMNDiagram.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("id","definitions.expressionLanguage","definitions.namespace","definitions.nameHolder","definitions.id","definitions.description")).setTypedPropertyFields(Arrays.asList(true,true,true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("3,-1,-1,-1,4")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.InputData.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("variable.typeRefHolder","stylingSet.bgColour","stylingSet.borderColour","stylingSet.fontFamily","stylingSet.fontColour","stylingSet.fontSize","dimensionsSet.width","dimensionsSet.height","linksHolder","nameHolder","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true,true,true,true,true,true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("9,6,7,-1,10")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("typeRefHolder")).setTypedPropertyFields(Arrays.asList(true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument.class, new DefinitionAdapterBindings().setBaseType(org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("expressionLanguage","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList()).setTypedPropertyFields(Arrays.asList()).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.Association.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("id","description")).setTypedPropertyFields(Arrays.asList(true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,0")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel.class, new DefinitionAdapterBindings().setBaseType(org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("expressionLanguage","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.UnaryTests.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("expressionLanguage","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.DecisionService.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("decisionServiceParametersList.value","variable.typeRefHolder","stylingSet.bgColour","stylingSet.borderColour","stylingSet.fontFamily","stylingSet.fontColour","stylingSet.fontSize","dimensionsSet.width","dimensionsSet.height","dividerLineY","linksHolder","nameHolder","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true,true,true,true,true,true,true,true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("11,7,8,-1,12")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.InformationItem.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("typeRefHolder","nameHolder","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("1,-1,-1,-1,2")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("type","locationURI","stylingSet.bgColour","stylingSet.borderColour","stylingSet.fontFamily","stylingSet.fontColour","stylingSet.fontSize","dimensionsSet.width","dimensionsSet.height","linksHolder","nameHolder","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true,true,true,true,true,true,true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("10,7,8,-1,11")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.Decision.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("question","allowedAnswers","variable.typeRefHolder","stylingSet.bgColour","stylingSet.borderColour","stylingSet.fontFamily","stylingSet.fontColour","stylingSet.fontSize","dimensionsSet.width","dimensionsSet.height","linksHolder","nameHolder","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true,true,true,true,true,true,true,true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("11,8,9,-1,12")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList()).setTypedPropertyFields(Arrays.asList()).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.InformationRequirement.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList()).setTypedPropertyFields(Arrays.asList()).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.dmn.api.definition.model.InputClause.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("stunnerLabels").setCategoryField("stunnerCategory").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("inputExpression.typeRefHolder","inputExpression.text","inputValues.text","inputValues.constraintTypeProperty","id","description")).setTypedPropertyFields(Arrays.asList(true,true,true,true,true,true)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,4")));
    }

    @Override
    public String getBaseType(Class<?> type) {
        return adapter.getBaseType(type);
    }

    @Override
    public String[] getTypes(String baseType) {
        return adapter.getTypes(baseType);
    }

}