/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.HasTypeRefs;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.common.HasTypeRefHelper;
import org.mockito.Mockito;

public class HasTypeRefHelperTest {
    @Test
    public void testGetNotNullHasTypeRefs() {
        HasTypeRef hasTypeRef = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList((HasTypeRef)Mockito.mock(HasTypeRef.class), (HasTypeRef)Mockito.mock(HasTypeRef.class));
        Mockito.when((Object)hasTypeRef.getHasTypeRefs()).thenReturn(expectedHasTypeRefs);
        List actualHasTypeRefs = HasTypeRefHelper.getNotNullHasTypeRefs((HasTypeRef)hasTypeRef);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testGetNotNullHasTypeRefsWhenHasTypeRefIsNull() {
        List expectedHasTypeRefs = Collections.emptyList();
        List actualHasTypeRefs = HasTypeRefHelper.getNotNullHasTypeRefs(null);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testGetFlatHasTypeRefs() {
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef5 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef6 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        List<HasTypeRef> typeRefList1 = Arrays.asList(hasTypeRef3, hasTypeRef4);
        List<HasTypeRef> typeRefList2 = Arrays.asList(hasTypeRef5, hasTypeRef6);
        List<HasTypeRefs> hasTypeRefs = Arrays.asList(hasTypeRef1, hasTypeRef2);
        Mockito.when((Object)hasTypeRef1.getHasTypeRefs()).thenReturn(typeRefList1);
        Mockito.when((Object)hasTypeRef2.getHasTypeRefs()).thenReturn(typeRefList2);
        List actual = HasTypeRefHelper.getFlatHasTypeRefs(hasTypeRefs);
        List<HasTypeRef> expected = Arrays.asList(hasTypeRef3, hasTypeRef4, hasTypeRef5, hasTypeRef6);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testGetFlatHasTypeRefsFromExpressions() {
        Expression expression1 = (Expression)Mockito.mock(Expression.class);
        Expression expression2 = (Expression)Mockito.mock(Expression.class);
        DMNModelInstrumentedBase parent = (DMNModelInstrumentedBase)Mockito.mock(DMNModelInstrumentedBase.class);
        HasExpression hasExpression1 = HasExpression.wrap((DMNModelInstrumentedBase)parent, (Expression)expression1);
        HasExpression hasExpression2 = HasExpression.wrap((DMNModelInstrumentedBase)parent, (Expression)expression2);
        List<HasExpression> hasExpressions = Arrays.asList(hasExpression1, hasExpression2);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef3 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef4 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        List<HasTypeRef> typeRefList1 = Arrays.asList(hasTypeRef1, hasTypeRef2);
        List<HasTypeRef> typeRefList2 = Arrays.asList(hasTypeRef3, hasTypeRef4);
        Mockito.when((Object)expression1.getHasTypeRefs()).thenReturn(typeRefList1);
        Mockito.when((Object)expression2.getHasTypeRefs()).thenReturn(typeRefList2);
        List actual = HasTypeRefHelper.getFlatHasTypeRefsFromExpressions(hasExpressions);
        List<HasTypeRef> expected = Arrays.asList(hasTypeRef1, hasTypeRef2, hasTypeRef3, hasTypeRef4);
        Assert.assertEquals(expected, (Object)actual);
    }
}

