/*
* Copyright 2019 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.model.formBuilder.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;

import org.kie.workbench.common.forms.adf.definitions.settings.ColSpan;
import org.kie.workbench.common.forms.adf.service.building.FieldStatusModifier;
import org.kie.workbench.common.forms.adf.service.building.FormGenerationResourcesProvider;
import org.kie.workbench.common.forms.adf.service.definitions.FormDefinitionSettings;
import org.kie.workbench.common.forms.adf.service.definitions.I18nSettings;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FieldElement;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FormElement;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutColumnDefinition;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutDefinition;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.TypeKind;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;

@Generated("org.kie.workbench.common.forms.adf.processors.FormDefinitionsProcessor")
@ApplicationScoped
public class ModuleFormGenerationResourcesProvider implements FormGenerationResourcesProvider {

    private Map<String, FormDefinitionSettings> definitionSettings = new HashMap<>();

    private Map<String, FieldStatusModifier> fieldStatusModifiers = new HashMap<>();

    private Map<String, String> fieldStatusModifiersReferences = new HashMap<>();

    public ModuleFormGenerationResourcesProvider() {
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression", new org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.InformationRequirement", new org_kie_workbench_common_dmn_api_definition_model_InformationRequirementFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel", new org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.TextAnnotation", new org_kie_workbench_common_dmn_api_definition_model_TextAnnotationFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListSet", new org_kie_workbench_common_dmn_api_property_dmn_DecisionServiceParametersListSetFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression", new org_kie_workbench_common_dmn_api_definition_model_OutputClauseLiteralExpressionFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.InputClause", new org_kie_workbench_common_dmn_api_definition_model_InputClauseFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.NOPDomainObject", new org_kie_workbench_common_dmn_api_definition_NOPDomainObjectFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument", new org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.OutputClause", new org_kie_workbench_common_dmn_api_definition_model_OutputClauseFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.LiteralExpression", new org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.DMNDiagram", new org_kie_workbench_common_dmn_api_definition_model_DMNDiagramFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.InputData", new org_kie_workbench_common_dmn_api_definition_model_InputDataFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests", new org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.DecisionService", new org_kie_workbench_common_dmn_api_definition_model_DecisionServiceFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.InformationItem", new org_kie_workbench_common_dmn_api_definition_model_InformationItemFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel", new org_kie_workbench_common_dmn_api_definition_model_BusinessKnowledgeModelFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.Decision", new org_kie_workbench_common_dmn_api_definition_model_DecisionFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement", new org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.property.styling.StylingSet", new org_kie_workbench_common_dmn_api_property_styling_StylingSetFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement", new org_kie_workbench_common_dmn_api_definition_model_AuthorityRequirementFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.Association", new org_kie_workbench_common_dmn_api_definition_model_AssociationFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests", new org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.Definitions", new org_kie_workbench_common_dmn_api_definition_model_DefinitionsFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource", new org_kie_workbench_common_dmn_api_definition_model_KnowledgeSourceFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.ImportedValues", new org_kie_workbench_common_dmn_api_definition_model_ImportedValuesFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.UnaryTests", new org_kie_workbench_common_dmn_api_definition_model_UnaryTestsFormBuilder().getSettings());
        definitionSettings.put("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary", new org_kie_workbench_common_dmn_api_definition_model_InformationItemPrimaryFormBuilder().getSettings());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_DocumentationLinksHolder_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_DocumentationLinksHolder_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_styling_FontSize_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_styling_FontSize_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dimensions_Height_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dimensions_Height_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_LocationURI_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_LocationURI_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_styling_BgColour_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_styling_BgColour_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_DecisionServiceParametersListHolder_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_DecisionServiceParametersListHolder_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswers_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswers_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_styling_FontColour_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_styling_FontColour_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_KnowledgeSourceType_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_KnowledgeSourceType_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_styling_BorderSize_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_styling_BorderSize_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_styling_FontFamily_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_styling_FontFamily_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_styling_BorderColour_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_styling_BorderColour_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_Question_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_Question_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dmn_TextFormat_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dmn_TextFormat_FieldStatusModifier());
        fieldStatusModifiers.put("org_kie_workbench_common_dmn_api_property_dimensions_Width_FieldStatusModifier", new org_kie_workbench_common_dmn_api_property_dimensions_Width_FieldStatusModifier());
    }

    @Override
    public Map<String, FormDefinitionSettings> getDefinitionSettings() {
        return definitionSettings;
    }

    @Override
    public Map<String, FieldStatusModifier> getFieldModifiers() {
        return fieldStatusModifiers;
    }

    @Override
    public Map<String, String> getFieldModifierReferences() {
        return fieldStatusModifiersReferences;
    }

    class org_kie_workbench_common_dmn_api_definition_model_InputClauseLiteralExpressionFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_text());
            elements.add(getFormElement_typeRefHolder());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement("text", "text.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression.text");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_typeRefHolder() {
            FieldElement field = new FieldElement("typeRefHolder", "typeRefHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.QName", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.QNameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("text");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression.typeRefHolder", "org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_InformationRequirementFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.InformationRequirement");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.InformationRequirement"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            settings.getFormElements().addAll(elements);
            return settings;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentModelFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_expressionLanguage());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement("expressionLanguage", "expressionLanguage.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_TextAnnotationFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.TextAnnotation");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.TextAnnotation"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_text());
            elements.add(getFormElement_textFormat());
            elements.add(getFormElement_stylingSet());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement("text", "text.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.TextAnnotation.text");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.TextAnnotation.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_textFormat() {
            FieldElement field = new FieldElement("textFormat", "textFormat.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.TextFormat.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.TextFormat.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("text");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.TextAnnotation.textFormat", "org_kie_workbench_common_dmn_api_property_dmn_TextFormat_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_stylingSet() {
            FieldElement field = new FieldElement("stylingSet", "stylingSet", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.styling.StylingSet", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.TextAnnotation.org.kie.workbench.common.dmn.api.property.styling.StylingSet.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.TextAnnotation.org.kie.workbench.common.dmn.api.property.styling.StylingSet.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("variable");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_DecisionServiceParametersListSetFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListSet");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListSet"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_value());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_value() {
            FieldElement field = new FieldElement("value", "value.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersList", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.DecisionParametersListFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListSet.value", "org_kie_workbench_common_dmn_api_property_dmn_DecisionServiceParametersListHolder_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_OutputClauseLiteralExpressionFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_text());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement("text", "text.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression.text");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_InputClauseFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.InputClause");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.InputClause"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_inputExpression());
            elements.add(getFormElement_inputValues());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_inputExpression() {
            FieldElement field = new FieldElement("inputExpression", "inputExpression", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InputClause.inputExpression");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.InputClause.org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }

        private FormElement getFormElement_inputValues() {
            FieldElement field = new FieldElement("inputValues", "inputValues", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InputClause.inputValues");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.InputClause.org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("inputExpression");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_NOPDomainObjectFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.NOPDomainObject");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.NOPDomainObject"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            settings.getFormElements().addAll(elements);
            return settings;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionPMMLDocumentFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_expressionLanguage());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement("expressionLanguage", "expressionLanguage.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_OutputClauseFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.OutputClause");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.OutputClause"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_outputValues());
            elements.add(getFormElement_defaultOutputEntry());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_outputValues() {
            FieldElement field = new FieldElement("outputValues", "outputValues", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.OutputClause.outputValues");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.OutputClause.org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }

        private FormElement getFormElement_defaultOutputEntry() {
            FieldElement field = new FieldElement("defaultOutputEntry", "defaultOutputEntry", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.OutputClause.defaultOutputEntry");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.OutputClause.org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("outputValues");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_LiteralExpressionFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.LiteralExpression");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.LiteralExpression"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_expressionLanguage());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement("expressionLanguage", "expressionLanguage.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_DMNDiagramFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.DMNDiagram");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.DMNDiagram"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_definitions());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNDiagram.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_definitions() {
            FieldElement field = new FieldElement("definitions", "definitions", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.Definitions", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.Definitions.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.Definitions.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_InputDataFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.InputData");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.InputData"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_linksHolder());
            elements.add(getFormElement_nameHolder());
            elements.add(getFormElement_variable());
            elements.add(getFormElement_stylingSet());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_linksHolder() {
            FieldElement field = new FieldElement("linksHolder", "linksHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DRGElement.linksHolder", "org_kie_workbench_common_dmn_api_property_dmn_DocumentationLinksHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_nameHolder() {
            FieldElement field = new FieldElement("nameHolder", "nameHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.Name", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.NameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.NameHolder.label");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.NamedElement.nameHolder", "org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_variable() {
            FieldElement field = new FieldElement("variable", "variable", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("nameHolder");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }

        private FormElement getFormElement_stylingSet() {
            FieldElement field = new FieldElement("stylingSet", "stylingSet", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.styling.StylingSet", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("variable");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_InputClauseUnaryTestsFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_text());
            elements.add(getFormElement_constraintTypeProperty());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement("text", "text.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests.text");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_constraintTypeProperty() {
            FieldElement field = new FieldElement("constraintTypeProperty", "constraintTypeProperty.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.type.ListBoxFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests.constraintType");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("addEmptyOption", "expression");
            field.getParams().put("org.kie.workbench.common.forms.adf.definitions.annotations.field.selector.SelectorDataProvider", "local:org.kie.workbench.common.dmn.api.property.dmn.dataproviders.ConstraintTypeDataProvider");
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("text");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests.constraintTypeProperty", "org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_DecisionServiceFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.DecisionService");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.DecisionService"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_linksHolder());
            elements.add(getFormElement_nameHolder());
            elements.add(getFormElement_decisionServiceParametersList());
            elements.add(getFormElement_variable());
            elements.add(getFormElement_stylingSet());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_linksHolder() {
            FieldElement field = new FieldElement("linksHolder", "linksHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DRGElement.linksHolder", "org_kie_workbench_common_dmn_api_property_dmn_DocumentationLinksHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_nameHolder() {
            FieldElement field = new FieldElement("nameHolder", "nameHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.Name", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.NameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.NameHolder.label");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.NamedElement.nameHolder", "org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_decisionServiceParametersList() {
            FieldElement field = new FieldElement("decisionServiceParametersList", "decisionServiceParametersList", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListSet", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListSet.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListSet.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("nameHolder");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }

        private FormElement getFormElement_variable() {
            FieldElement field = new FieldElement("variable", "variable", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("decisionServiceParametersList");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }

        private FormElement getFormElement_stylingSet() {
            FieldElement field = new FieldElement("stylingSet", "stylingSet", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.styling.StylingSet", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("variable");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_InformationItemFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.InformationItem");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.InformationItem"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_nameHolder());
            elements.add(getFormElement_typeRefHolder());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_nameHolder() {
            FieldElement field = new FieldElement("nameHolder", "nameHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.Name", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.NameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.NameHolder.label");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.NamedElement.nameHolder", "org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_typeRefHolder() {
            FieldElement field = new FieldElement("typeRefHolder", "typeRefHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.QName", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.QNameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("nameHolder");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.InformationItem.typeRefHolder", "org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_BusinessKnowledgeModelFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_linksHolder());
            elements.add(getFormElement_nameHolder());
            elements.add(getFormElement_variable());
            elements.add(getFormElement_stylingSet());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_linksHolder() {
            FieldElement field = new FieldElement("linksHolder", "linksHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DRGElement.linksHolder", "org_kie_workbench_common_dmn_api_property_dmn_DocumentationLinksHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_nameHolder() {
            FieldElement field = new FieldElement("nameHolder", "nameHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.Name", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.NameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.NameHolder.label");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.NamedElement.nameHolder", "org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_variable() {
            FieldElement field = new FieldElement("variable", "variable", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("nameHolder");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }

        private FormElement getFormElement_stylingSet() {
            FieldElement field = new FieldElement("stylingSet", "stylingSet", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.styling.StylingSet", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("variable");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_DecisionFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.Decision");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.Decision"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_linksHolder());
            elements.add(getFormElement_nameHolder());
            elements.add(getFormElement_question());
            elements.add(getFormElement_allowedAnswers());
            elements.add(getFormElement_variable());
            elements.add(getFormElement_stylingSet());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_linksHolder() {
            FieldElement field = new FieldElement("linksHolder", "linksHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DRGElement.linksHolder", "org_kie_workbench_common_dmn_api_property_dmn_DocumentationLinksHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_nameHolder() {
            FieldElement field = new FieldElement("nameHolder", "nameHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.Name", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.NameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.NameHolder.label");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.NamedElement.nameHolder", "org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_question() {
            FieldElement field = new FieldElement("question", "question.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Question.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Question.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("nameHolder");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.Decision.question", "org_kie_workbench_common_dmn_api_property_dmn_Question_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_allowedAnswers() {
            FieldElement field = new FieldElement("allowedAnswers", "allowedAnswers.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("question");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.Decision.allowedAnswers", "org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswers_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_variable() {
            FieldElement field = new FieldElement("variable", "variable", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("allowedAnswers");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }

        private FormElement getFormElement_stylingSet() {
            FieldElement field = new FieldElement("stylingSet", "stylingSet", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.styling.StylingSet", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_KnowledgeRequirementFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            settings.getFormElements().addAll(elements);
            return settings;
        }
    }

    class org_kie_workbench_common_dmn_api_property_styling_StylingSetFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.property.styling.StylingSet");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.property.styling.StylingSet"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_bgColour());
            elements.add(getFormElement_borderColour());
            elements.add(getFormElement_fontFamily());
            elements.add(getFormElement_fontColour());
            elements.add(getFormElement_fontSize());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_bgColour() {
            FieldElement field = new FieldElement("bgColour", "bgColour.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.stunner.forms.model.ColorPickerFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.BgColour.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.BgColour.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.property.styling.StylingSet.bgColour", "org_kie_workbench_common_dmn_api_property_styling_BgColour_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_borderColour() {
            FieldElement field = new FieldElement("borderColour", "borderColour.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.stunner.forms.model.ColorPickerFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.BorderColour.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.BorderColour.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("bgColour");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.property.styling.StylingSet.borderColour", "org_kie_workbench_common_dmn_api_property_styling_BorderColour_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_fontFamily() {
            FieldElement field = new FieldElement("fontFamily", "fontFamily.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.FontFamily.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.FontFamily.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.property.styling.StylingSet.fontFamily", "org_kie_workbench_common_dmn_api_property_styling_FontFamily_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_fontColour() {
            FieldElement field = new FieldElement("fontColour", "fontColour.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.stunner.forms.model.ColorPickerFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.FontColour.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.FontColour.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("fontFamily");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.property.styling.StylingSet.fontColour", "org_kie_workbench_common_dmn_api_property_styling_FontColour_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_fontSize() {
            FieldElement field = new FieldElement("fontSize", "fontSize.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.Double", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.slider.type.SliderFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.FontSize.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.FontSize.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("step", "1.0");
            field.getParams().put("min", "8.0");
            field.getParams().put("max", "24.0");
            field.getLayoutSettings().setAfterElement("fontColour");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.property.styling.StylingSet.fontSize", "org_kie_workbench_common_dmn_api_property_styling_FontSize_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_AuthorityRequirementFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            settings.getFormElements().addAll(elements);
            return settings;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_AssociationFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.Association");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.Association"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_OutputClauseUnaryTestsFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_text());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_text() {
            FieldElement field = new FieldElement("text", "text.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests.text");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.OutputClauseUnaryTests.text", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_DefinitionsFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.Definitions");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.Definitions"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_nameHolder());
            elements.add(getFormElement_expressionLanguage());
            elements.add(getFormElement_namespace());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_nameHolder() {
            FieldElement field = new FieldElement("nameHolder", "nameHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.Name", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.NameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.Definitions.nameHolder");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.Definitions.nameHolder", "org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement("expressionLanguage", "expressionLanguage.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("nameHolder");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.Definitions.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_namespace() {
            FieldElement field = new FieldElement("namespace", "namespace.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.definition.model.Definitions.namespace");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("expressionLanguage");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.Definitions.namespace", "org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_KnowledgeSourceFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_linksHolder());
            elements.add(getFormElement_nameHolder());
            elements.add(getFormElement_type());
            elements.add(getFormElement_locationURI());
            elements.add(getFormElement_stylingSet());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_linksHolder() {
            FieldElement field = new FieldElement("linksHolder", "linksHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DRGElement.linksHolder", "org_kie_workbench_common_dmn_api_property_dmn_DocumentationLinksHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_nameHolder() {
            FieldElement field = new FieldElement("nameHolder", "nameHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.Name", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.NameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.NameHolder.label");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.NamedElement.nameHolder", "org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_type() {
            FieldElement field = new FieldElement("type", "type.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("nameHolder");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource.type", "org_kie_workbench_common_dmn_api_property_dmn_KnowledgeSourceType_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_locationURI() {
            FieldElement field = new FieldElement("locationURI", "locationURI.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.LocationURI.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.LocationURI.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("type");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource.locationURI", "org_kie_workbench_common_dmn_api_property_dmn_LocationURI_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_stylingSet() {
            FieldElement field = new FieldElement("stylingSet", "stylingSet", new TypeInfoImpl(TypeKind.OBJECT, "org.kie.workbench.common.dmn.api.property.styling.StylingSet", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.styling.StylingSet.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("locationURI");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_ImportedValuesFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.ImportedValues");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.ImportedValues"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_nameHolder());
            elements.add(getFormElement_expressionLanguage());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_nameHolder() {
            FieldElement field = new FieldElement("nameHolder", "nameHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.Name", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.NameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.NameHolder.label");
            field.setHelpMessageKey("");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.NamedElement.nameHolder", "org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement("expressionLanguage", "expressionLanguage.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.ImportedValues.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_UnaryTestsFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.UnaryTests");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.UnaryTests"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_id());
            elements.add(getFormElement_description());
            elements.add(getFormElement_expressionLanguage());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_id() {
            FieldElement field = new FieldElement("id", "id.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Id.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Id.helpMessage");
            field.setRequired(false);
            field.setReadOnly(true);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.id", "org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_description() {
            FieldElement field = new FieldElement("description", "description.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textArea.type.TextAreaFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.Description.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.Description.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("id");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.DMNElement.description", "org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier");
            return field;
        }

        private FormElement getFormElement_expressionLanguage() {
            FieldElement field = new FieldElement("expressionLanguage", "expressionLanguage.value", new TypeInfoImpl(TypeKind.BASE, "java.lang.String", false));
            field.setPreferredType(org.kie.workbench.common.forms.model.FieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getParams().put("nestedFormContainer", "COLLAPSIBLE");
            field.getLayoutSettings().setAfterElement("description");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.UnaryTests.expressionLanguage", "org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_definition_model_InformationItemPrimaryFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary");
            settings.setI18nSettings(new I18nSettings("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary"));
            settings.setLayout(new LayoutDefinition(new LayoutColumnDefinition[] { new LayoutColumnDefinition(ColSpan.AUTO) }));
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add(getFormElement_typeRefHolder());
            settings.getFormElements().addAll(elements);
            return settings;
        }

        private FormElement getFormElement_typeRefHolder() {
            FieldElement field = new FieldElement("typeRefHolder", "typeRefHolder.value", new TypeInfoImpl(TypeKind.BASE, "org.kie.workbench.common.dmn.api.property.dmn.QName", false));
            field.setPreferredType(org.kie.workbench.common.dmn.api.property.dmn.QNameFieldType.class);
            field.setLabelKey("org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.label");
            field.setHelpMessageKey("org.kie.workbench.common.dmn.api.property.dmn.QNameHolder.helpMessage");
            field.setRequired(false);
            field.setReadOnly(false);
            field.getLayoutSettings().setAfterElement("");
            field.getLayoutSettings().setHorizontalSpan(1);
            field.getLayoutSettings().setVerticalSpan(1);
            field.getLayoutSettings().setWrap(false);
            fieldStatusModifiersReferences.put("org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary.typeRefHolder", "org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier");
            return field;
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_DocumentationLinksHolder_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_styling_FontSize_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.styling.FontSize> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.styling.FontSize model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_ExpressionLanguage_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dimensions_Height_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dimensions.Height> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dimensions.Height model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_LocationURI_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.LocationURI> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.LocationURI model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_QNameHolder_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.QNameHolder> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.QNameHolder model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_styling_BgColour_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.styling.BgColour> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.styling.BgColour model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_DecisionServiceParametersListHolder_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListHolder> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceParametersListHolder model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_NameHolder_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.NameHolder> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.NameHolder model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_AllowedAnswers_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Text_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Text> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Text model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_styling_FontColour_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.styling.FontColour> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.styling.FontColour model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_ConstraintTypeProperty_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.ConstraintTypeProperty> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.ConstraintTypeProperty model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Id_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Id> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Id model) {
            if (model != null) {
                field.setReadOnly(Boolean.TRUE.equals(model.isReadOnly()));
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Description_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Description> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Description model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_KnowledgeSourceType_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.KnowledgeSourceType model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_styling_BorderSize_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.styling.BorderSize> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.styling.BorderSize model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_styling_FontFamily_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.styling.FontFamily> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.styling.FontFamily model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_styling_BorderColour_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.styling.BorderColour> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.styling.BorderColour model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_Question_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.Question> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.Question model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dmn_TextFormat_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dmn.TextFormat> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dmn.TextFormat model) {
            if (model != null) {
            }
        }
    }

    class org_kie_workbench_common_dmn_api_property_dimensions_Width_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.dmn.api.property.dimensions.Width> {
        @Override
        public void modifyFieldStatus(FieldDefinition field, org.kie.workbench.common.dmn.api.property.dimensions.Width model) {
            if (model != null) {
            }
        }
    }
}
