/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.rules.NoInputNodesInImportedDecisionRule;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class NoInputNodesInImportedDecisionRuleTest {
    @Mock
    protected RuleExtension rule;
    protected NoInputNodesInImportedDecisionRule check;
    @Mock
    protected GraphConnectionContext context;
    @Mock
    protected View content;
    @Mock
    protected DynamicReadOnly definition;

    @Before
    public void setup() {
        this.check = (NoInputNodesInImportedDecisionRule)Mockito.spy((Object)new NoInputNodesInImportedDecisionRule());
        Node target = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.definition.isAllowOnlyVisualChange()).thenReturn((Object)true);
        Mockito.when((Object)this.content.getDefinition()).thenReturn((Object)this.definition);
        Mockito.when((Object)target.getContent()).thenReturn((Object)this.content);
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.of(target));
    }

    @Test
    public void testMissingTargetNodeDoesNotTriggerCheck() {
        Node source = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(source));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.empty());
        RuleViolations result = this.check.evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.violations().iterator().hasNext());
        ((NoInputNodesInImportedDecisionRule)Mockito.verify((Object)this.check, (VerificationMode)Mockito.never())).isReadOnly((Optional)ArgumentMatchers.any(Optional.class));
    }

    @Test
    public void testEvaluate() {
        Node source = (Node)Mockito.mock(Node.class);
        Node target = (Node)Mockito.mock(Node.class);
        View content = (View)Mockito.mock(View.class);
        DynamicReadOnly dynamicReadonly = (DynamicReadOnly)Mockito.mock(DynamicReadOnly.class);
        Mockito.when((Object)dynamicReadonly.isAllowOnlyVisualChange()).thenReturn((Object)true);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)dynamicReadonly);
        Mockito.when((Object)target.getContent()).thenReturn((Object)content);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(source));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.of(target));
        RuleViolations result = this.check.evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        RuleViolation violation = (RuleViolation)result.violations().iterator().next();
        Assert.assertNotNull((Object)violation);
        Assert.assertTrue((boolean)violation.getArguments().isPresent());
        Assert.assertEquals((long)1L, (long)((Object[])violation.getArguments().get()).length);
        Assert.assertEquals((Object)"Imported nodes can not have input nodes.", (Object)((Object[])violation.getArguments().get())[0]);
    }

    @Test
    public void testIsReadOnly() {
        Node target = (Node)Mockito.mock(Node.class);
        View content = (View)Mockito.mock(View.class);
        DynamicReadOnly dynamicReadonly = (DynamicReadOnly)Mockito.mock(DynamicReadOnly.class);
        Mockito.when((Object)dynamicReadonly.isAllowOnlyVisualChange()).thenReturn((Object)true);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)dynamicReadonly);
        Mockito.when((Object)target.getContent()).thenReturn((Object)content);
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.of(target));
        boolean actual = this.check.isReadOnly(Optional.of(target));
        Assert.assertTrue((boolean)actual);
        ((NoInputNodesInImportedDecisionRule)Mockito.verify((Object)this.check)).isReadOnly((Optional)ArgumentMatchers.any(Optional.class));
    }

    @Test
    public void testAcceptWhenIsExpectedClass() {
        Mockito.when((Object)this.rule.getId()).thenReturn((Object)this.definition.getClass().getName());
        boolean actual = this.check.accepts(this.rule, this.context);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testAcceptWhenIsNotExpectedClass() {
        Mockito.when((Object)this.rule.getId()).thenReturn((Object)"SomeOtherClass");
        boolean actual = this.check.accepts(this.rule, this.context);
        Assert.assertFalse((boolean)actual);
    }
}

