/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionRuleTest {
    private static final String DECISION_RULE_ID = "DECISION_RULE_ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private DecisionRule decisionRule;

    @Before
    public void setup() {
        this.decisionRule = (DecisionRule)Mockito.spy((Object)new DecisionRule());
    }

    @Test
    public void testGetHasTypeRefs() {
        LiteralExpression literalExpression1 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        LiteralExpression literalExpression2 = (LiteralExpression)Mockito.mock(LiteralExpression.class);
        List<LiteralExpression> outputEntry = Arrays.asList(literalExpression1, literalExpression2);
        ((DecisionRule)Mockito.doReturn(outputEntry).when((Object)this.decisionRule)).getOutputEntry();
        PowerMockito.when((Object)literalExpression1.getHasTypeRefs()).thenReturn(Arrays.asList(literalExpression1));
        PowerMockito.when((Object)literalExpression2.getHasTypeRefs()).thenReturn(Arrays.asList(literalExpression2));
        List actualHasTypeRefs = this.decisionRule.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(literalExpression1, literalExpression2);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testCopy() {
        DecisionRule source = new DecisionRule(new Id(DECISION_RULE_ID), new Description(DESCRIPTION), new ArrayList(), new ArrayList());
        DecisionRule target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)DECISION_RULE_ID, (Object)target.getId().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertTrue((boolean)target.getInputEntry().isEmpty());
        Assert.assertTrue((boolean)target.getOutputEntry().isEmpty());
    }
}

