/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.v1_1;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;

public class DMNModelInstrumentedBaseTest {
    private static final String DUMMY_URI = "http://http://www.kiegroup.org";

    @Test
    public void testParent() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        child.setParent(parent);
        Assert.assertEquals((Object)((Object)parent), (Object)child.getParent());
    }

    @Test
    public void testGetPrefixForNamespaceURIInheritance() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    @Test
    public void testGetPrefixForNamespaceURIOverride() {
        MockDMNModelClass parent = new MockDMNModelClass();
        MockDMNModelClass child = new MockDMNModelClass();
        parent.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        child.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DUMMY_URI);
        child.setParent(parent);
        Optional parentFeelPrefix = parent.getPrefixForNamespaceURI(DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Assert.assertTrue((boolean)parentFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), parentFeelPrefix.get());
        Optional childFeelPrefix = child.getPrefixForNamespaceURI(DUMMY_URI);
        Assert.assertTrue((boolean)childFeelPrefix.isPresent());
        Assert.assertEquals((Object)DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), childFeelPrefix.get());
    }

    public class MockDMNModelClass
    extends DMNModelInstrumentedBase {
    }
}

