/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.jboss.errai.marshalling.server.ServerMarshalling;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.InformationRequirement;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.dmndi.Bounds;
import org.kie.dmn.model.api.dmndi.Color;
import org.kie.dmn.model.api.dmndi.DMNDI;
import org.kie.dmn.model.api.dmndi.DMNShape;
import org.kie.dmn.model.api.dmndi.DMNStyle;
import org.kie.dmn.model.api.dmndi.Point;
import org.kie.dmn.model.api.dmndi.Style;
import org.kie.dmn.model.v1_1.KieDMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.TDMNElement;
import org.kie.dmn.model.v1_2.TDMNElement;
import org.kie.dmn.model.v1_2.TDefinitions;
import org.kie.dmn.model.v1_2.dmndi.DMNDiagram;
import org.kie.dmn.model.v1_2.dmndi.DMNEdge;
import org.kie.dmn.model.v1_2.dmndi.DMNLabel;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.DMNViewDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.Association;
import org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.background.BgColour;
import org.kie.workbench.common.dmn.api.property.background.BorderColour;
import org.kie.workbench.common.dmn.api.property.dimensions.Height;
import org.kie.workbench.common.dmn.api.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dimensions.Width;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.backend.definition.v1_1.AssociationConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.BusinessKnowledgeModelConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DecisionConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DefinitionsConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InputDataConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.KnowledgeSourceConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.TextAnnotationConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ColorUtils;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.FontSetPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.PointUtils;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;

@ApplicationScoped
public class DMNMarshaller
implements DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>> {
    private XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller;
    private FactoryManager factoryManager;
    private InputDataConverter inputDataConverter;
    private DecisionConverter decisionConverter;
    private BusinessKnowledgeModelConverter bkmConverter;
    private KnowledgeSourceConverter knowledgeSourceConverter;
    private TextAnnotationConverter textAnnotationConverter;
    private org.kie.dmn.api.marshalling.DMNMarshaller marshaller;

    protected DMNMarshaller() {
        this(null, null);
    }

    @Inject
    public DMNMarshaller(XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller, FactoryManager factoryManager) {
        this.diagramMetadataMarshaller = diagramMetadataMarshaller;
        this.factoryManager = factoryManager;
        this.inputDataConverter = new InputDataConverter(factoryManager);
        this.decisionConverter = new DecisionConverter(factoryManager);
        this.bkmConverter = new BusinessKnowledgeModelConverter(factoryManager);
        this.knowledgeSourceConverter = new KnowledgeSourceConverter(factoryManager);
        this.textAnnotationConverter = new TextAnnotationConverter(factoryManager);
        this.marshaller = DMNMarshallerFactory.newDefaultMarshaller();
    }

    @Deprecated
    public Graph unmarshallFromStunnerJSON(Metadata metadata, InputStream input) throws IOException {
        Graph result = (Graph)ServerMarshalling.fromJSON((InputStream)input);
        return result;
    }

    @Deprecated
    public String marshallFromStunnerToJSON(Diagram<Graph, Metadata> diagram) throws IOException {
        String result = ServerMarshalling.toJSON((Object)diagram.getGraph());
        return result;
    }

    private static Optional<org.kie.dmn.model.api.dmndi.DMNDiagram> findDMNDiagram(Definitions dmnXml) {
        if (!(dmnXml instanceof TDefinitions)) {
            return Optional.empty();
        }
        if (dmnXml.getDMNDI() == null) {
            return Optional.empty();
        }
        List elems = dmnXml.getDMNDI().getDMNDiagram();
        if (elems.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(elems.get(0));
    }

    public Graph unmarshall(Metadata metadata, InputStream input) throws IOException {
        Node currentNode;
        Object elem;
        Definitions dmnXml = this.marshaller.unmarshal((Reader)new InputStreamReader(input));
        Map<String, Map.Entry> elems = dmnXml.getDrgElement().stream().collect(Collectors.toMap(DMNElement::getId, dmn -> new AbstractMap.SimpleEntry<DRGElement, Node>((DRGElement)dmn, this.dmnToStunner((DRGElement)dmn))));
        Optional<org.kie.dmn.model.api.dmndi.DMNDiagram> dmnDDDiagram = DMNMarshaller.findDMNDiagram(dmnXml);
        for (Map.Entry kv : elems.values()) {
            elem = (DRGElement)kv.getKey();
            currentNode = (Node)kv.getValue();
            this.ddExtAugmentStunner(dmnDDDiagram, currentNode);
        }
        for (Map.Entry kv : elems.values()) {
            Edge myEdge;
            Node requiredNode;
            String reqInputID;
            elem = (DRGElement)kv.getKey();
            currentNode = (Node)kv.getValue();
            if (elem instanceof Decision) {
                Decision decision = (Decision)elem;
                for (InformationRequirement ir : decision.getInformationRequirement()) {
                    if (ir.getRequiredInput() != null) {
                        reqInputID = this.getId(ir.getRequiredInput());
                        requiredNode = (Node)elems.get(reqInputID).getValue();
                        myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)ir), org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class).asEdge();
                        DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                        this.setConnectionMagnets(myEdge, ir.getId(), dmnXml);
                    }
                    if (ir.getRequiredDecision() == null) continue;
                    reqInputID = this.getId(ir.getRequiredDecision());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)ir), org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement.class).asEdge();
                    DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge, ir.getId(), dmnXml);
                }
                for (org.kie.dmn.model.api.KnowledgeRequirement kr : decision.getKnowledgeRequirement()) {
                    reqInputID = this.getId(kr.getRequiredKnowledge());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)kr), KnowledgeRequirement.class).asEdge();
                    DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge, kr.getId(), dmnXml);
                }
                for (org.kie.dmn.model.api.KnowledgeRequirement kr : decision.getAuthorityRequirement()) {
                    reqInputID = this.getId(kr.getRequiredAuthority());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)kr), AuthorityRequirement.class).asEdge();
                    DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge, kr.getId(), dmnXml);
                }
                continue;
            }
            if (elem instanceof org.kie.dmn.model.api.BusinessKnowledgeModel) {
                org.kie.dmn.model.api.BusinessKnowledgeModel bkm = (org.kie.dmn.model.api.BusinessKnowledgeModel)elem;
                for (org.kie.dmn.model.api.KnowledgeRequirement kr : bkm.getKnowledgeRequirement()) {
                    reqInputID = this.getId(kr.getRequiredKnowledge());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)kr), KnowledgeRequirement.class).asEdge();
                    DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge, kr.getId(), dmnXml);
                }
                for (org.kie.dmn.model.api.KnowledgeRequirement kr : bkm.getAuthorityRequirement()) {
                    reqInputID = this.getId(kr.getRequiredAuthority());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)kr), AuthorityRequirement.class).asEdge();
                    DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge, kr.getId(), dmnXml);
                }
                continue;
            }
            if (!(elem instanceof org.kie.dmn.model.api.KnowledgeSource)) continue;
            org.kie.dmn.model.api.KnowledgeSource ks = (org.kie.dmn.model.api.KnowledgeSource)elem;
            for (InformationRequirement ir : ks.getAuthorityRequirement()) {
                if (ir.getRequiredInput() != null) {
                    reqInputID = this.getId(ir.getRequiredInput());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)ir), AuthorityRequirement.class).asEdge();
                    DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge, ir.getId(), dmnXml);
                }
                if (ir.getRequiredDecision() != null) {
                    reqInputID = this.getId(ir.getRequiredDecision());
                    requiredNode = (Node)elems.get(reqInputID).getValue();
                    myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)ir), AuthorityRequirement.class).asEdge();
                    DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                    this.setConnectionMagnets(myEdge, ir.getId(), dmnXml);
                }
                if (ir.getRequiredAuthority() == null) continue;
                reqInputID = this.getId(ir.getRequiredAuthority());
                requiredNode = (Node)elems.get(reqInputID).getValue();
                myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)ir), AuthorityRequirement.class).asEdge();
                DMNMarshaller.connectEdge(myEdge, requiredNode, currentNode);
                this.setConnectionMagnets(myEdge, ir.getId(), dmnXml);
            }
        }
        Map<String, Node> textAnnotations = dmnXml.getArtifact().stream().filter(org.kie.dmn.model.api.TextAnnotation.class::isInstance).map(org.kie.dmn.model.api.TextAnnotation.class::cast).collect(Collectors.toMap(DMNElement::getId, this.textAnnotationConverter::nodeFromDMN));
        textAnnotations.values().forEach(n -> this.ddExtAugmentStunner(dmnDDDiagram, (Node)n));
        List associations = dmnXml.getArtifact().stream().filter(org.kie.dmn.model.api.Association.class::isInstance).map(org.kie.dmn.model.api.Association.class::cast).collect(Collectors.toList());
        for (org.kie.dmn.model.api.Association a : associations) {
            String sourceId = this.getId(a.getSourceRef());
            Node sourceNode = Optional.ofNullable(elems.get(sourceId)).map(Map.Entry::getValue).orElse(textAnnotations.get(sourceId));
            String targetId = this.getId(a.getTargetRef());
            Node targetNode = Optional.ofNullable(elems.get(targetId)).map(Map.Entry::getValue).orElse(textAnnotations.get(targetId));
            Edge myEdge = this.factoryManager.newElement(DMNMarshaller.idOfDMNorWBUUID((DMNElement)a), Association.class).asEdge();
            Id id = new Id(a.getId());
            Description description = new Description(a.getDescription());
            Association definition = new Association(id, description);
            ((View)myEdge.getContent()).setDefinition((Object)definition);
            DMNMarshaller.connectEdge(myEdge, sourceNode, targetNode);
            this.setConnectionMagnets(myEdge, a.getId(), dmnXml);
        }
        Graph graph = this.factoryManager.newDiagram("prova", BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class), metadata).getGraph();
        elems.values().stream().map(Map.Entry::getValue).forEach(arg_0 -> ((Graph)graph).addNode(arg_0));
        textAnnotations.values().forEach(arg_0 -> ((Graph)graph).addNode(arg_0));
        Node<?, ?> dmnDiagramRoot = DMNMarshaller.findDMNDiagramRoot(graph);
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions definitionsStunnerPojo = DefinitionsConverter.wbFromDMN(dmnXml);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).setDefinitions(definitionsStunnerPojo);
        elems.values().stream().map(Map.Entry::getValue).forEach(node -> DMNMarshaller.connectRootWithChild(dmnDiagramRoot, node));
        textAnnotations.values().stream().forEach(node -> DMNMarshaller.connectRootWithChild(dmnDiagramRoot, node));
        return graph;
    }

    private static String idOfDMNorWBUUID(DMNElement dmn) {
        return dmn.getId() != null ? dmn.getId() : UUID.uuid();
    }

    public static Node<?, ?> findDMNDiagramRoot(Graph<?, Node<View, ?>> graph) {
        return StreamSupport.stream(graph.nodes().spliterator(), false).filter(n -> ((View)n.getContent()).getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram).findFirst().orElseThrow(() -> new UnsupportedOperationException("TODO"));
    }

    private String getId(DMNElementReference er) {
        String href = er.getHref();
        return href.contains("#") ? href.substring(href.indexOf(35) + 1) : href;
    }

    private Node dmnToStunner(DRGElement dmn) {
        if (dmn instanceof InputData) {
            return this.inputDataConverter.nodeFromDMN((InputData)dmn);
        }
        if (dmn instanceof Decision) {
            return this.decisionConverter.nodeFromDMN((Decision)dmn);
        }
        if (dmn instanceof org.kie.dmn.model.api.BusinessKnowledgeModel) {
            return this.bkmConverter.nodeFromDMN((org.kie.dmn.model.api.BusinessKnowledgeModel)dmn);
        }
        if (dmn instanceof org.kie.dmn.model.api.KnowledgeSource) {
            return this.knowledgeSourceConverter.nodeFromDMN((org.kie.dmn.model.api.KnowledgeSource)dmn);
        }
        throw new UnsupportedOperationException("TODO");
    }

    public static void connectRootWithChild(Node dmnDiagramRoot, Node child) {
        String uuid = UUID.uuid();
        EdgeImpl edge = new EdgeImpl(uuid);
        edge.setContent((Object)new Child());
        DMNMarshaller.connectEdge((Edge)edge, dmnDiagramRoot, child);
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions definitions = ((org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).getDefinitions();
        org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase childDRG = (org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase)((View)child.getContent()).getDefinition();
        childDRG.setParent((org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase)definitions);
    }

    public static void connectEdge(Edge edge, Node source, Node target) {
        edge.setSourceNode(source);
        edge.setTargetNode(target);
        source.getOutEdges().add(edge);
        target.getInEdges().add(edge);
    }

    private void setConnectionMagnets(Edge edge, String dmnEdgeElementRef, Definitions dmnXml) {
        ViewConnector connectionContent = (ViewConnector)edge.getContent();
        Optional<org.kie.dmn.model.api.dmndi.DMNDiagram> dmnDiagram = DMNMarshaller.findDMNDiagram(dmnXml);
        Optional<Object> dmnEdge = Optional.empty();
        if (dmnDiagram.isPresent()) {
            dmnEdge = dmnDiagram.get().getDMNDiagramElement().stream().filter(org.kie.dmn.model.api.dmndi.DMNEdge.class::isInstance).map(org.kie.dmn.model.api.dmndi.DMNEdge.class::cast).filter(e -> e.getDmnElementRef().getLocalPart().equals(dmnEdgeElementRef)).findFirst();
        }
        if (dmnEdge.isPresent()) {
            org.kie.dmn.model.api.dmndi.DMNEdge e2 = (org.kie.dmn.model.api.dmndi.DMNEdge)dmnEdge.get();
            Point source = (Point)e2.getWaypoint().get(0);
            Node sourceNode = edge.getSourceNode();
            if (null != sourceNode) {
                View sourceView = (View)sourceNode.getContent();
                double xSource = DMNMarshaller.xOfBound(DMNMarshaller.upperLeftBound(sourceView));
                double ySource = DMNMarshaller.yOfBound(DMNMarshaller.upperLeftBound(sourceView));
                connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.at((double)(source.getX() - xSource), (double)(source.getY() - ySource)));
            }
            Point target = (Point)e2.getWaypoint().get(e2.getWaypoint().size() - 1);
            Node targetNode = edge.getTargetNode();
            if (null != targetNode) {
                View targetView = (View)targetNode.getContent();
                double xTarget = DMNMarshaller.xOfBound(DMNMarshaller.upperLeftBound(targetView));
                double yTarget = DMNMarshaller.yOfBound(DMNMarshaller.upperLeftBound(targetView));
                connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.at((double)(target.getX() - xTarget), (double)(target.getY() - yTarget)));
            }
            if (e2.getWaypoint().size() > 2) {
                List sublist = e2.getWaypoint().subList(1, e2.getWaypoint().size() - 1);
                for (Point p : sublist) {
                    connectionContent.getControlPoints().add(ControlPoint.build((Point2D)PointUtils.dmndiPointToPoint2D(p)));
                }
            }
        } else {
            Node targetNode;
            Node sourceNode = edge.getSourceNode();
            if (null != sourceNode) {
                connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.forElement((Element)sourceNode));
            }
            if (null != (targetNode = edge.getTargetNode())) {
                connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.forElement((Element)targetNode));
            }
        }
    }

    public String marshall(Diagram<Graph, Metadata> diagram) throws IOException {
        Graph g = diagram.getGraph();
        HashMap<String, DRGElement> nodes = new HashMap<String, DRGElement>();
        HashMap<String, org.kie.dmn.model.api.TextAnnotation> textAnnotations = new HashMap<String, org.kie.dmn.model.api.TextAnnotation>();
        Node<?, ?> dmnDiagramRoot = DMNMarshaller.findDMNDiagramRoot(g);
        org.kie.workbench.common.dmn.api.definition.v1_1.Definitions definitionsStunnerPojo = ((org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram)((View)dmnDiagramRoot.getContent()).getDefinition()).getDefinitions();
        Definitions definitions = DefinitionsConverter.dmnFromWB(definitionsStunnerPojo);
        if (definitions.getExtensionElements() == null) {
            if (definitions instanceof KieDMNModelInstrumentedBase) {
                definitions.setExtensionElements((DMNElement.ExtensionElements)new TDMNElement.TExtensionElements());
            } else if (definitions instanceof org.kie.dmn.model.v1_2.KieDMNModelInstrumentedBase) {
                definitions.setExtensionElements((DMNElement.ExtensionElements)new TDMNElement.TExtensionElements());
            } else {
                definitions.setExtensionElements((DMNElement.ExtensionElements)new TDMNElement.TExtensionElements());
            }
        }
        if (definitions.getDMNDI() == null) {
            definitions.setDMNDI((DMNDI)new org.kie.dmn.model.v1_2.dmndi.DMNDI());
        }
        DMNDiagram dmnDDDMNDiagram = new DMNDiagram();
        definitions.getDMNDI().getDMNDiagram().add(dmnDDDMNDiagram);
        ArrayList<DMNEdge> dmnEdges = new ArrayList<DMNEdge>();
        for (Node node : g.nodes()) {
            if (!(node.getContent() instanceof View)) continue;
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement) {
                org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement n2 = (org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement)view.getDefinition();
                nodes.put(n2.getId().getValue(), this.stunnerToDMN(node));
                dmnDDDMNDiagram.getDMNDiagramElement().add(DMNMarshaller.stunnerToDDExt((View<? extends org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement>)view));
            } else if (view.getDefinition() instanceof TextAnnotation) {
                TextAnnotation textAnnotation = (TextAnnotation)view.getDefinition();
                textAnnotations.put(textAnnotation.getId().getValue(), this.textAnnotationConverter.dmnFromNode((Node<View<TextAnnotation>, ?>)node));
                dmnDDDMNDiagram.getDMNDiagramElement().add(DMNMarshaller.stunnerToDDExt((View<? extends org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement>)view));
                List<org.kie.dmn.model.api.Association> associations = AssociationConverter.dmnFromWB(node);
                definitions.getArtifact().addAll(associations);
            }
            List inEdges = node.getInEdges();
            for (Edge e : inEdges) {
                double yTarget;
                double xTarget;
                double ySource;
                double xSource;
                View sourceView;
                ViewConnector connectionContent;
                if (!(e.getContent() instanceof ViewConnector) || !(connectionContent = (ViewConnector)e.getContent()).getSourceConnection().isPresent() || !connectionContent.getTargetConnection().isPresent()) continue;
                Point2D sourcePoint = ((Connection)connectionContent.getSourceConnection().get()).getLocation();
                Point2D targetPoint = ((Connection)connectionContent.getTargetConnection().get()).getLocation();
                if (sourcePoint == null) {
                    sourceView = (View)e.getSourceNode().getContent();
                    xSource = DMNMarshaller.xOfBound(DMNMarshaller.upperLeftBound(sourceView));
                    ySource = DMNMarshaller.yOfBound(DMNMarshaller.upperLeftBound(sourceView));
                    if (sourceView.getDefinition() instanceof DMNViewDefinition) {
                        DMNViewDefinition dmnViewDefinition = (DMNViewDefinition)sourceView.getDefinition();
                        xSource += dmnViewDefinition.getDimensionsSet().getWidth().getValue() / 2.0;
                        ySource += dmnViewDefinition.getDimensionsSet().getHeight().getValue() / 2.0;
                    }
                    sourcePoint = Point2D.create((double)xSource, (double)ySource);
                } else {
                    sourceView = (View)e.getSourceNode().getContent();
                    xSource = DMNMarshaller.xOfBound(DMNMarshaller.upperLeftBound(sourceView));
                    ySource = DMNMarshaller.yOfBound(DMNMarshaller.upperLeftBound(sourceView));
                    sourcePoint = Point2D.create((double)(xSource + sourcePoint.getX()), (double)(ySource + sourcePoint.getY()));
                }
                if (targetPoint == null) {
                    xTarget = DMNMarshaller.xOfBound(DMNMarshaller.upperLeftBound(view));
                    yTarget = DMNMarshaller.yOfBound(DMNMarshaller.upperLeftBound(view));
                    if (view.getDefinition() instanceof DMNViewDefinition) {
                        DMNViewDefinition dmnViewDefinition = (DMNViewDefinition)view.getDefinition();
                        xTarget += dmnViewDefinition.getDimensionsSet().getWidth().getValue() / 2.0;
                        yTarget += dmnViewDefinition.getDimensionsSet().getHeight().getValue() / 2.0;
                    }
                    targetPoint = Point2D.create((double)xTarget, (double)yTarget);
                } else {
                    xTarget = DMNMarshaller.xOfBound(DMNMarshaller.upperLeftBound(view));
                    yTarget = DMNMarshaller.yOfBound(DMNMarshaller.upperLeftBound(view));
                    targetPoint = Point2D.create((double)(xTarget + targetPoint.getX()), (double)(yTarget + targetPoint.getY()));
                }
                DMNEdge dmnEdge = new DMNEdge();
                dmnEdge.setId("dmnedge-" + e.getUUID());
                dmnEdge.setDmnElementRef(new QName(e.getUUID()));
                dmnEdge.getWaypoint().add(PointUtils.point2dToDMNDIPoint(sourcePoint));
                for (ControlPoint cp : connectionContent.getControlPoints()) {
                    dmnEdge.getWaypoint().add(PointUtils.point2dToDMNDIPoint(cp.getLocation()));
                }
                dmnEdge.getWaypoint().add(PointUtils.point2dToDMNDIPoint(targetPoint));
                dmnEdges.add(dmnEdge);
            }
        }
        nodes.values().forEach(n -> {
            n.setParent((DMNModelInstrumentedBase)definitions);
            definitions.getDrgElement().add(n);
        });
        textAnnotations.values().forEach(definitions.getArtifact()::add);
        dmnDDDMNDiagram.getDMNDiagramElement().addAll(dmnEdges);
        return this.marshaller.marshal((Object)definitions);
    }

    private void ddExtAugmentStunner(Optional<org.kie.dmn.model.api.dmndi.DMNDiagram> dmnDDDiagram, Node currentNode) {
        if (!dmnDDDiagram.isPresent()) {
            return;
        }
        Stream<DMNShape> drgShapeStream = dmnDDDiagram.get().getDMNDiagramElement().stream().filter(DMNShape.class::isInstance).map(DMNShape.class::cast);
        View content = (View)currentNode.getContent();
        if (content.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.Decision) {
            org.kie.workbench.common.dmn.api.definition.v1_1.Decision d = (org.kie.workbench.common.dmn.api.definition.v1_1.Decision)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), DMNMarshaller.upperLeftBound(content), d.getDimensionsSet(), DMNMarshaller.lowerRightBound(content), d.getBackgroundSet(), arg_0 -> ((org.kie.workbench.common.dmn.api.definition.v1_1.Decision)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.InputData) {
            org.kie.workbench.common.dmn.api.definition.v1_1.InputData d = (org.kie.workbench.common.dmn.api.definition.v1_1.InputData)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), DMNMarshaller.upperLeftBound(content), d.getDimensionsSet(), DMNMarshaller.lowerRightBound(content), d.getBackgroundSet(), arg_0 -> ((org.kie.workbench.common.dmn.api.definition.v1_1.InputData)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof BusinessKnowledgeModel) {
            BusinessKnowledgeModel d = (BusinessKnowledgeModel)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), DMNMarshaller.upperLeftBound(content), d.getDimensionsSet(), DMNMarshaller.lowerRightBound(content), d.getBackgroundSet(), arg_0 -> ((BusinessKnowledgeModel)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof KnowledgeSource) {
            KnowledgeSource d = (KnowledgeSource)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), DMNMarshaller.upperLeftBound(content), d.getDimensionsSet(), DMNMarshaller.lowerRightBound(content), d.getBackgroundSet(), arg_0 -> ((KnowledgeSource)d).setFontSet(arg_0));
        } else if (content.getDefinition() instanceof TextAnnotation) {
            TextAnnotation d = (TextAnnotation)content.getDefinition();
            this.internalAugment(drgShapeStream, d.getId(), DMNMarshaller.upperLeftBound(content), d.getDimensionsSet(), DMNMarshaller.lowerRightBound(content), d.getBackgroundSet(), arg_0 -> ((TextAnnotation)d).setFontSet(arg_0));
        }
    }

    private void internalAugment(Stream<DMNShape> drgShapeStream, Id id, Bounds.Bound ul, RectangleDimensionsSet dimensionsSet, Bounds.Bound lr, BackgroundSet bgset, Consumer<FontSet> fontSetSetter) {
        DMNStyle dmnStyleOfDrgShape;
        Optional<DMNShape> drgShapeOpt = drgShapeStream.filter(shape -> shape.getDmnElementRef().getLocalPart().equals(id.getValue())).findFirst();
        if (!drgShapeOpt.isPresent()) {
            return;
        }
        DMNShape drgShape = drgShapeOpt.get();
        if (ul != null) {
            ((BoundImpl)ul).setX(Double.valueOf(DMNMarshaller.xOfShape(drgShape)));
            ((BoundImpl)ul).setY(Double.valueOf(DMNMarshaller.yOfShape(drgShape)));
        }
        dimensionsSet.setWidth(new Width(Double.valueOf(DMNMarshaller.widthOfShape(drgShape))));
        dimensionsSet.setHeight(new Height(Double.valueOf(DMNMarshaller.heightOfShape(drgShape))));
        if (lr != null) {
            ((BoundImpl)lr).setX(Double.valueOf(DMNMarshaller.xOfShape(drgShape) + DMNMarshaller.widthOfShape(drgShape)));
            ((BoundImpl)lr).setY(Double.valueOf(DMNMarshaller.yOfShape(drgShape) + DMNMarshaller.heightOfShape(drgShape)));
        }
        DMNStyle dMNStyle = dmnStyleOfDrgShape = drgShape.getStyle() instanceof DMNStyle ? (DMNStyle)drgShape.getStyle() : null;
        if (dmnStyleOfDrgShape != null) {
            if (null != dmnStyleOfDrgShape.getFillColor()) {
                bgset.setBgColour(new BgColour(ColorUtils.wbFromDMN(dmnStyleOfDrgShape.getFillColor())));
            }
            if (null != dmnStyleOfDrgShape.getStrokeColor()) {
                bgset.setBorderColour(new BorderColour(ColorUtils.wbFromDMN(dmnStyleOfDrgShape.getStrokeColor())));
            }
        }
        FontSet fontSet = new FontSet();
        if (dmnStyleOfDrgShape != null && dmnStyleOfDrgShape.getFontFamily() != null) {
            DMNMarshaller.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN(dmnStyleOfDrgShape));
        }
        if (drgShape.getDMNLabel() != null && drgShape.getDMNLabel().getSharedStyle() instanceof DMNStyle) {
            DMNMarshaller.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN((DMNStyle)drgShape.getDMNLabel().getSharedStyle()));
        }
        if (drgShape.getDMNLabel() != null && drgShape.getDMNLabel().getStyle() instanceof DMNStyle) {
            DMNMarshaller.mergeFontSet(fontSet, FontSetPropertyConverter.wbFromDMN((DMNStyle)drgShape.getDMNLabel().getStyle()));
        }
        fontSetSetter.accept(fontSet);
    }

    private static void mergeFontSet(FontSet fontSet, FontSet additional) {
        if (additional.getFontFamily() != null) {
            fontSet.setFontFamily(additional.getFontFamily());
        }
        if (additional.getFontSize() != null) {
            fontSet.setFontSize(additional.getFontSize());
        }
        if (additional.getFontColour() != null) {
            fontSet.setFontColour(additional.getFontColour());
        }
    }

    private static DMNShape stunnerToDDExt(View<? extends org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement> v) {
        org.kie.dmn.model.v1_2.dmndi.DMNShape result = new org.kie.dmn.model.v1_2.dmndi.DMNShape();
        result.setId("dmnshape-" + ((org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement)v.getDefinition()).getId().getValue());
        result.setDmnElementRef(new QName(((org.kie.workbench.common.dmn.api.definition.v1_1.DMNElement)v.getDefinition()).getId().getValue()));
        org.kie.dmn.model.v1_2.dmndi.Bounds bounds = new org.kie.dmn.model.v1_2.dmndi.Bounds();
        result.setBounds((Bounds)bounds);
        bounds.setX(DMNMarshaller.xOfBound(DMNMarshaller.upperLeftBound(v)));
        bounds.setY(DMNMarshaller.yOfBound(DMNMarshaller.upperLeftBound(v)));
        result.setStyle((Style)new org.kie.dmn.model.v1_2.dmndi.DMNStyle());
        result.setDMNLabel((org.kie.dmn.model.api.dmndi.DMNLabel)new DMNLabel());
        if (v.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.Decision) {
            org.kie.workbench.common.dmn.api.definition.v1_1.Decision d = (org.kie.workbench.common.dmn.api.definition.v1_1.Decision)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), (Bounds)bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), (DMNShape)result);
            DMNMarshaller.applyFontStyle(d.getFontSet(), (DMNShape)result);
        } else if (v.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.InputData) {
            org.kie.workbench.common.dmn.api.definition.v1_1.InputData d = (org.kie.workbench.common.dmn.api.definition.v1_1.InputData)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), (Bounds)bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), (DMNShape)result);
            DMNMarshaller.applyFontStyle(d.getFontSet(), (DMNShape)result);
        } else if (v.getDefinition() instanceof BusinessKnowledgeModel) {
            BusinessKnowledgeModel d = (BusinessKnowledgeModel)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), (Bounds)bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), (DMNShape)result);
            DMNMarshaller.applyFontStyle(d.getFontSet(), (DMNShape)result);
        } else if (v.getDefinition() instanceof KnowledgeSource) {
            KnowledgeSource d = (KnowledgeSource)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), (Bounds)bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), (DMNShape)result);
            DMNMarshaller.applyFontStyle(d.getFontSet(), (DMNShape)result);
        } else if (v.getDefinition() instanceof TextAnnotation) {
            TextAnnotation d = (TextAnnotation)v.getDefinition();
            DMNMarshaller.applyBounds(d.getDimensionsSet(), (Bounds)bounds);
            DMNMarshaller.applyBackgroundStyles(d.getBackgroundSet(), (DMNShape)result);
            DMNMarshaller.applyFontStyle(d.getFontSet(), (DMNShape)result);
        }
        return result;
    }

    private static void applyFontStyle(FontSet fontSet, DMNShape result) {
        if (!(result.getStyle() instanceof DMNStyle)) {
            return;
        }
        DMNStyle shapeStyle = (DMNStyle)result.getStyle();
        Color fontColor = ColorUtils.dmnFromWB(fontSet.getFontColour().getValue());
        shapeStyle.setFontColor(fontColor);
        if (null != fontSet.getFontFamily().getValue()) {
            shapeStyle.setFontFamily(fontSet.getFontFamily().getValue());
        }
        if (null != fontSet.getFontSize().getValue()) {
            shapeStyle.setFontSize(fontSet.getFontSize().getValue());
        }
    }

    private static void applyBounds(RectangleDimensionsSet dimensionsSet, Bounds bounds) {
        if (null != dimensionsSet.getWidth().getValue() && null != dimensionsSet.getHeight().getValue()) {
            bounds.setWidth(dimensionsSet.getWidth().getValue().doubleValue());
            bounds.setHeight(dimensionsSet.getHeight().getValue().doubleValue());
        }
    }

    private static void applyBackgroundStyles(BackgroundSet bgset, DMNShape result) {
        if (!(result.getStyle() instanceof DMNStyle)) {
            return;
        }
        DMNStyle style = (DMNStyle)result.getStyle();
        if (null != bgset.getBgColour().getValue()) {
            style.setFillColor(ColorUtils.dmnFromWB(bgset.getBgColour().getValue()));
        }
        if (null != bgset.getBorderColour().getValue()) {
            style.setStrokeColor(ColorUtils.dmnFromWB(bgset.getBorderColour().getValue()));
        }
    }

    private DRGElement stunnerToDMN(Node<?, ?> node) {
        if (node.getContent() instanceof View) {
            View view = (View)node.getContent();
            if (view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.InputData) {
                return this.inputDataConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.InputData>, ?>)node);
            }
            if (view.getDefinition() instanceof org.kie.workbench.common.dmn.api.definition.v1_1.Decision) {
                return this.decisionConverter.dmnFromNode((Node<View<org.kie.workbench.common.dmn.api.definition.v1_1.Decision>, ?>)node);
            }
            if (view.getDefinition() instanceof BusinessKnowledgeModel) {
                return this.bkmConverter.dmnFromNode((Node<View<BusinessKnowledgeModel>, ?>)node);
            }
            if (view.getDefinition() instanceof KnowledgeSource) {
                return this.knowledgeSourceConverter.dmnFromNode((Node<View<KnowledgeSource>, ?>)node);
            }
            throw new UnsupportedOperationException("TODO");
        }
        throw new RuntimeException("wrong diagram structure to marshall");
    }

    public DiagramMetadataMarshaller<Metadata> getMetadataMarshaller() {
        return this.diagramMetadataMarshaller;
    }

    private static Bounds.Bound upperLeftBound(View view) {
        if (view != null && view.getBounds() != null) {
            return view.getBounds().getUpperLeft();
        }
        return null;
    }

    private static Bounds.Bound lowerRightBound(View view) {
        if (view != null && view.getBounds() != null) {
            return view.getBounds().getLowerRight();
        }
        return null;
    }

    private static double xOfBound(Bounds.Bound bound) {
        if (bound != null) {
            return bound.getX();
        }
        return 0.0;
    }

    private static double yOfBound(Bounds.Bound bound) {
        if (bound != null) {
            return bound.getY();
        }
        return 0.0;
    }

    private static double xOfShape(DMNShape shape) {
        if (shape != null && shape.getBounds() != null) {
            return shape.getBounds().getX();
        }
        return 0.0;
    }

    private static double yOfShape(DMNShape shape) {
        if (shape != null && shape.getBounds() != null) {
            return shape.getBounds().getY();
        }
        return 0.0;
    }

    private static double widthOfShape(DMNShape shape) {
        if (shape != null && shape.getBounds() != null) {
            return shape.getBounds().getWidth();
        }
        return 0.0;
    }

    private static double heightOfShape(DMNShape shape) {
        if (shape != null && shape.getBounds() != null) {
            return shape.getBounds().getHeight();
        }
        return 0.0;
    }
}

