/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.kie.workbench.common.dmn.api.resource.DMNDefinitionSetResourceType;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.editors.types.query.DMNValueFileExtensionIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.types.query.DMNValueRepositoryRootIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.types.query.FindAllDmnAssetsQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.RefactoringQueryServiceImpl;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DMNPathsHelperImpl
implements DMNPathsHelper {
    static final String STANDALONE_URI = "default://master@system/stunner/diagrams";
    static final String STANDALONE_FILE_NAME = "diagrams";
    private final RefactoringQueryServiceImpl refactoringQueryService;
    private final DMNDefinitionSetResourceType resourceType;
    private final IOService ioService;

    public DMNPathsHelperImpl() {
        this(null, null, null);
    }

    @Inject
    public DMNPathsHelperImpl(RefactoringQueryServiceImpl refactoringQueryService, DMNDefinitionSetResourceType resourceType, @Named(value="ioStrategy") IOService ioService) {
        this.refactoringQueryService = refactoringQueryService;
        this.resourceType = resourceType;
        this.ioService = ioService;
    }

    @Override
    public List<org.uberfire.backend.vfs.Path> getDiagramsPaths(WorkspaceProject workspaceProject) {
        if (workspaceProject != null) {
            return this.getPathsByWorkspaceProject(workspaceProject);
        }
        return this.getStandalonePaths();
    }

    private List<org.uberfire.backend.vfs.Path> getStandalonePaths() {
        return StreamSupport.stream(this.getDMNPaths().spliterator(), false).map(this::convertPath).collect(Collectors.toList());
    }

    private List<org.uberfire.backend.vfs.Path> getPathsByWorkspaceProject(WorkspaceProject workspaceProject) {
        RefactoringPageRequest request = this.buildRequest(workspaceProject.getRootPath().toURI());
        return this.refactoringQueryService.query(request).getPageRowList().stream().map(row -> (org.uberfire.backend.vfs.Path)row.getValue()).collect(Collectors.toList());
    }

    private RefactoringPageRequest buildRequest(String rootPath) {
        return new RefactoringPageRequest(FindAllDmnAssetsQuery.NAME, this.queryTerms(rootPath), 0, Integer.valueOf(1000), Boolean.TRUE);
    }

    private Set<ValueIndexTerm> queryTerms(String rootPath) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add(new DMNValueRepositoryRootIndexTerm(rootPath));
        queryTerms.add(new DMNValueFileExtensionIndexTerm());
        return queryTerms;
    }

    DirectoryStream<Path> getDMNPaths() {
        Path root = this.getStandaloneRootPath();
        return this.ioService.newDirectoryStream(root, this.dmnAssetsFilter());
    }

    DirectoryStream.Filter<Path> dmnAssetsFilter() {
        return path -> this.resourceType.accept(this.convertPath((Path)path));
    }

    Path getStandaloneRootPath() {
        return this.convertPath(this.newPath(STANDALONE_FILE_NAME, STANDALONE_URI));
    }

    org.uberfire.backend.vfs.Path newPath(String fileName, String uri) {
        return PathFactory.newPath((String)fileName, (String)uri);
    }

    Path convertPath(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }

    org.uberfire.backend.vfs.Path convertPath(Path path) {
        return Paths.convert((Path)path);
    }
}

