/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.included;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModelsService;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelperStandalone;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ImportedItemDefinitionConverter;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodesFilter;
import org.kie.workbench.common.dmn.backend.editors.common.IncludedModelFactory;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentsFilter;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.uberfire.backend.vfs.Path;

@Service
public class DMNIncludedModelsServiceImpl
implements DMNIncludedModelsService {
    private static Logger LOGGER = Logger.getLogger(DMNIncludedModelsServiceImpl.class.getName());
    private final DMNPathsHelper pathsHelper;
    private final IncludedModelFactory includedModelFactory;
    private final DMNIncludedNodesFilter includedNodesFilter;
    private final PMMLIncludedDocumentsFilter includedDocumentsFilter;
    private final DMNMarshallerImportsHelperStandalone importsHelper;

    @Inject
    public DMNIncludedModelsServiceImpl(DMNPathsHelper pathsHelper, IncludedModelFactory includedModelFactory, DMNIncludedNodesFilter includedNodesFilter, PMMLIncludedDocumentsFilter includedDocumentsFilter, DMNMarshallerImportsHelperStandalone importsHelper) {
        this.pathsHelper = pathsHelper;
        this.includedModelFactory = includedModelFactory;
        this.includedNodesFilter = includedNodesFilter;
        this.includedDocumentsFilter = includedDocumentsFilter;
        this.importsHelper = importsHelper;
    }

    public List<IncludedModel> loadModels(Path path, WorkspaceProject workspaceProject) {
        return this.getModelsPaths(workspaceProject).stream().map(includedModelPath -> this.getPathToIncludeModelBiFunction().apply(path, (Path)includedModelPath)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DMNIncludedNode> loadNodesFromImports(WorkspaceProject workspaceProject, List<DMNIncludedModel> includedModels) {
        return this.getDMNModelsPaths(workspaceProject).stream().map(path -> this.includedNodesFilter.getNodesFromImports((Path)path, includedModels)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<PMMLDocumentMetadata> loadPMMLDocumentsFromImports(Path path, WorkspaceProject workspaceProject, List<PMMLIncludedModel> includedModels) {
        return this.getPMMLModelsPaths(workspaceProject).stream().map(includedModelPath -> this.includedDocumentsFilter.getDocumentFromImports(path, (Path)includedModelPath, includedModels)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ItemDefinition> loadItemDefinitionsByNamespace(WorkspaceProject workspaceProject, String modelName, String namespace) {
        return this.importsHelper.getImportedItemDefinitionsByNamespace(workspaceProject, modelName, namespace).stream().map(itemDefinition -> this.wbFromDMN((org.kie.dmn.model.api.ItemDefinition)itemDefinition, modelName)).collect(Collectors.toList());
    }

    private BiFunction<Path, Path, IncludedModel> getPathToIncludeModelBiFunction() {
        return (dmnModelPath, includedModelPath) -> {
            try {
                return this.includedModelFactory.create((Path)dmnModelPath, (Path)includedModelPath);
            }
            catch (DMNIncludeModelCouldNotBeCreatedException e) {
                LOGGER.warning("The 'IncludedModel' could not be created for " + includedModelPath.toURI());
                return null;
            }
        };
    }

    private List<Path> getModelsPaths(WorkspaceProject workspaceProject) {
        return this.pathsHelper.getModelsPaths(workspaceProject);
    }

    private List<Path> getDMNModelsPaths(WorkspaceProject workspaceProject) {
        return this.pathsHelper.getDMNModelsPaths(workspaceProject);
    }

    private List<Path> getPMMLModelsPaths(WorkspaceProject workspaceProject) {
        return this.pathsHelper.getPMMLModelsPaths(workspaceProject);
    }

    ItemDefinition wbFromDMN(org.kie.dmn.model.api.ItemDefinition itemDefinition, String modelName) {
        return ImportedItemDefinitionConverter.wbFromDMN(itemDefinition, modelName);
    }
}

