/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.validation;

import elemental2.dom.DomGlobal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.api.validation.DMNDomainValidator;
import org.kie.workbench.common.dmn.client.marshaller.DMNMarshallerService;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.validation.ClientDiagramValidator;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.DomainValidator;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.ModelValidator;
import org.kie.workbench.common.stunner.core.validation.impl.ElementViolationImpl;

@DMNEditor
@ApplicationScoped
public class DMNClientDiagramValidator
extends ClientDiagramValidator {
    private final Caller<DMNDomainValidator> dmnDomainValidator;
    private final DMNMarshallerService dmnMarshallerService;

    protected DMNClientDiagramValidator() {
        this(null, null, null, null, null, null, null);
    }

    @Inject
    public DMNClientDiagramValidator(DefinitionManager definitionManager, RuleManager ruleManager, TreeWalkTraverseProcessor treeWalkTraverseProcessor, ModelValidator modelValidator, ManagedInstance<DomainValidator> validators, Caller<DMNDomainValidator> dmnDomainValidator, DMNMarshallerService dmnMarshallerService) {
        super(definitionManager, ruleManager, treeWalkTraverseProcessor, modelValidator, validators);
        this.dmnDomainValidator = dmnDomainValidator;
        this.dmnMarshallerService = dmnMarshallerService;
    }

    public void validate(Diagram diagram, Consumer<Collection<DiagramElementViolation<RuleViolation>>> resultConsumer) {
        this.superValidate(diagram, this.getCollectionConsumer(diagram, resultConsumer));
    }

    Consumer<Collection<DiagramElementViolation<RuleViolation>>> getCollectionConsumer(Diagram diagram, Consumer<Collection<DiagramElementViolation<RuleViolation>>> resultConsumer) {
        return diagramElementViolations -> this.dmnMarshallerService.marshall(diagram, this.getContentServiceCallback(diagram, resultConsumer, (Collection<DiagramElementViolation<RuleViolation>>)diagramElementViolations));
    }

    ServiceCallback<String> getContentServiceCallback(final Diagram diagram, final Consumer<Collection<DiagramElementViolation<RuleViolation>>> resultConsumer, final Collection<DiagramElementViolation<RuleViolation>> diagramElementViolations) {
        return new ServiceCallback<String>(){

            public void onSuccess(String xml) {
                ((DMNDomainValidator)DMNClientDiagramValidator.this.dmnDomainValidator.call(DMNClientDiagramValidator.this.onValidatorSuccess(diagramElementViolations, resultConsumer), DMNClientDiagramValidator.this.onValidatorError())).validate(diagram, xml);
            }

            public void onError(ClientRuntimeError error) {
                DMNClientDiagramValidator.this.logError("Marshaller service error");
            }
        };
    }

    RemoteCallback<Collection<DomainViolation>> onValidatorSuccess(Collection<DiagramElementViolation<RuleViolation>> diagramElementViolations, Consumer<Collection<DiagramElementViolation<RuleViolation>>> resultConsumer) {
        return backendViolations -> {
            LinkedList<DiagramElementViolation<RuleViolation>> violations = this.getDiagramElementViolations(diagramElementViolations);
            violations.addAll(this.convert((Collection<DomainViolation>)backendViolations));
            resultConsumer.accept(violations);
        };
    }

    ErrorCallback<Object> onValidatorError() {
        return (msg, error) -> {
            this.logError("Validation service error");
            return false;
        };
    }

    void superValidate(Diagram diagram, Consumer<Collection<DiagramElementViolation<RuleViolation>>> resultConsumer) {
        super.validate(diagram, resultConsumer);
    }

    private List<ElementViolationImpl> convert(Collection<DomainViolation> backendViolations) {
        return backendViolations.stream().filter(v -> Objects.nonNull(v.getUUID())).filter(v -> !"null".equals(v.getUUID())).map(v -> new ElementViolationImpl.Builder().setUuid(v.getUUID()).setDomainViolations(Collections.singletonList(v)).build()).collect(Collectors.toList());
    }

    private LinkedList<DiagramElementViolation<RuleViolation>> getDiagramElementViolations(Collection<DiagramElementViolation<RuleViolation>> diagramElementViolations) {
        return Optional.ofNullable(diagramElementViolations).map(LinkedList::new).orElse(new LinkedList());
    }

    void logError(String errorMessage) {
        DomGlobal.console.error(new Object[]{"[DMNClientDiagramValidator] Error during validation: " + errorMessage});
    }
}

