/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import com.google.gwt.core.client.GWT;
import elemental2.promise.Promise;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.factory.DMNDiagramFactory;
import org.kie.workbench.common.dmn.client.DMNShapeSet;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNMarshallerKogitoMarshaller;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNMarshallerKogitoUnmarshaller;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12MarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.callbacks.DMN12UnmarshallCallback;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.DMN12;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDefinitions;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JSIName;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.kogito.api.editor.DiagramType;
import org.kie.workbench.common.stunner.kogito.api.editor.impl.KogitoDiagramResourceImpl;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;
import org.uberfire.commons.uuid.UUID;

@ApplicationScoped
public class DMNClientDiagramServiceImpl
implements KogitoClientDiagramService {
    private static final String DIAGRAMS_PATH = "diagrams";
    private static final String ROOT = "default://master@system/stunner/diagrams";
    private DMNMarshallerKogitoUnmarshaller dmnMarshallerKogitoUnmarshaller;
    private DMNMarshallerKogitoMarshaller dmnMarshallerKogitoMarshaller;
    private FactoryManager factoryManager;
    private DefinitionManager definitionManager;
    private DMNDiagramFactory dmnDiagramFactory;
    private Promises promises;

    public DMNClientDiagramServiceImpl() {
    }

    @Inject
    public DMNClientDiagramServiceImpl(DMNMarshallerKogitoUnmarshaller dmnMarshallerKogitoUnmarshaller, DMNMarshallerKogitoMarshaller dmnMarshallerKogitoMarshaller, FactoryManager factoryManager, DefinitionManager definitionManager, DMNDiagramFactory dmnDiagramFactory, Promises promises) {
        this.dmnMarshallerKogitoUnmarshaller = dmnMarshallerKogitoUnmarshaller;
        this.dmnMarshallerKogitoMarshaller = dmnMarshallerKogitoMarshaller;
        this.factoryManager = factoryManager;
        this.definitionManager = definitionManager;
        this.dmnDiagramFactory = dmnDiagramFactory;
        this.promises = promises;
    }

    public void transform(String xml, ServiceCallback<Diagram> callback) {
        if (Objects.isNull(xml) || xml.isEmpty()) {
            this.doNewDiagram(callback);
        } else {
            this.doTransformation(xml, callback);
        }
    }

    private void doNewDiagram(ServiceCallback<Diagram> callback) {
        String title = UUID.uuid();
        Metadata metadata = this.buildMetadataInstance();
        try {
            String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
            Diagram diagram = this.factoryManager.newDiagram(title, defSetId, metadata);
            this.updateClientShapeSetId(diagram);
            callback.onSuccess((Object)diagram);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Metadata buildMetadataInstance() {
        String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
        String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
        return new MetadataImpl.MetadataImplBuilder(defSetId, this.definitionManager).setRoot(PathFactory.newPath((String)".", (String)ROOT)).setShapeSetId(shapeSetId).build();
    }

    private void updateClientShapeSetId(Diagram diagram) {
        Metadata metadata;
        if (Objects.nonNull(diagram) && Objects.nonNull(metadata = diagram.getMetadata()) && StringUtils.isEmpty((String)metadata.getShapeSetId())) {
            String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
            metadata.setShapeSetId(shapeSetId);
        }
    }

    private void doTransformation(String xml, ServiceCallback<Diagram> callback) {
        Metadata metadata = this.buildMetadataInstance();
        try {
            DMN12UnmarshallCallback jsCallback = dmn12 -> {
                JSITDefinitions definitions = (JSITDefinitions)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)dmn12));
                Graph graph = this.dmnMarshallerKogitoUnmarshaller.unmarshall(metadata, definitions);
                Node diagramNode = GraphUtils.getFirstNode((Graph)graph, DMNDiagram.class);
                String title = ((DMNDiagram)((Definition)diagramNode.getContent()).getDefinition()).getDefinitions().getName().getValue();
                Diagram diagram = this.dmnDiagramFactory.build(title, metadata, graph);
                this.updateClientShapeSetId(diagram);
                callback.onSuccess((Object)diagram);
            };
            MainJs.unmarshall((String)xml, (String)"", (DMN12UnmarshallCallback)jsCallback);
        }
        catch (Exception e) {
            GWT.log((String)e.getMessage(), (Throwable)e);
            callback.onError(new ClientRuntimeError((Throwable)new DiagramParsingException(metadata, xml)));
        }
    }

    public Promise<String> transform(KogitoDiagramResourceImpl resource) {
        if (resource.getType() == DiagramType.PROJECT_DIAGRAM) {
            return this.promises.create((resolveCallbackFn, rejectCallbackFn) -> {
                if (resource.projectDiagram().isPresent()) {
                    Diagram diagram = (Diagram)resource.projectDiagram().get();
                    this.marshall(diagram, (Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String>)resolveCallbackFn, rejectCallbackFn);
                } else {
                    rejectCallbackFn.onInvoke((Object)new IllegalStateException("DiagramType is PROJECT_DIAGRAM however no instance present"));
                }
            });
        }
        return this.promises.resolve((Object)resource.xmlDiagram().orElse("DiagramType is XML_DIAGRAM however no instance present"));
    }

    private void marshall(Diagram diagram, Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<String> resolveCallbackFn, Promise.PromiseExecutorCallbackFn.RejectCallbackFn rejectCallbackFn) {
        if (Objects.isNull(diagram)) {
            return;
        }
        Graph graph = diagram.getGraph();
        if (Objects.isNull(graph)) {
            return;
        }
        DMN12MarshallCallback jsCallback = result -> {
            String xml = result;
            if (!xml.startsWith("<?xml version=\"1.0\" ?>")) {
                xml = "<?xml version=\"1.0\" ?>" + xml;
            }
            resolveCallbackFn.onInvoke((Object)xml);
        };
        try {
            JSITDefinitions jsitDefinitions = this.dmnMarshallerKogitoMarshaller.marshall(graph);
            DMN12 dmn12 = (DMN12)Js.uncheckedCast((Object)JsUtils.newWrappedInstance());
            JsUtils.setNameOnWrapped((Object)dmn12, (JSIName)this.makeJSINameForDMN12());
            JsUtils.setValueOnWrapped((Object)dmn12, (Object)jsitDefinitions);
            MainJs.marshall((DMN12)dmn12, (String)jsitDefinitions.getNamespace(), (DMN12MarshallCallback)jsCallback);
        }
        catch (Exception e) {
            GWT.log((String)e.getMessage(), (Throwable)e);
            rejectCallbackFn.onInvoke((Object)e);
        }
    }

    private JSIName makeJSINameForDMN12() {
        JSIName jsiName = JSITDefinitions.getJSIName();
        jsiName.setPrefix("dmn");
        jsiName.setLocalPart("definitions");
        String key = "{" + jsiName.getNamespaceURI() + "}" + jsiName.getLocalPart();
        String keyString = "{" + jsiName.getNamespaceURI() + "}" + jsiName.getPrefix() + ":" + jsiName.getLocalPart();
        jsiName.setKey(key);
        jsiName.setString(keyString);
        return jsiName;
    }
}

