/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.GeneralRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.AllowedAnswers;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Question;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.AllowedAnswersPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ExpressionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.HrefBuilder;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.NodeConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.QuestionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITAuthorityRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDMNElementReference;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDRGElement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITDecision;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationItem;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInformationRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITKnowledgeRequirement;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class DecisionConverter
implements NodeConverter<JSITDecision, Decision> {
    private FactoryManager factoryManager;

    public DecisionConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<Decision>, ?> nodeFromDMN(JSITDecision dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Node node = this.factoryManager.newElement(dmn.getId(), BindableAdapterUtils.getDefinitionId(Decision.class)).asNode();
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItemPrimary informationItem = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn.getVariable(), dmn);
        Expression expression = null;
        JSITExpression jsiWrapped = dmn.getExpression();
        if (Objects.nonNull(jsiWrapped)) {
            JSITExpression jsiExpression = (JSITExpression)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)jsiWrapped));
            expression = ExpressionPropertyConverter.wbFromDMN(jsiExpression, (JSITExpression)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        Decision decision = new Decision(id, description, name, new Question(), new AllowedAnswers(), informationItem, expression, new BackgroundSet(), new FontSet(), new GeneralRectangleDimensionsSet());
        decision.setQuestion(QuestionPropertyConverter.wbFromDMN(dmn.getQuestion()));
        decision.setAllowedAnswers(AllowedAnswersPropertyConverter.wbFromDMN(dmn.getAllowedAnswers()));
        ((View)node.getContent()).setDefinition((Object)decision);
        if (Objects.nonNull(informationItem)) {
            informationItem.setParent((DMNModelInstrumentedBase)decision);
        }
        if (Objects.nonNull(expression)) {
            expression.setParent((DMNModelInstrumentedBase)decision);
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((JSITDRGElement)dmn, (DRGElement)decision);
        return node;
    }

    @Override
    public JSITDecision dmnFromNode(Node<View<Decision>, ?> node, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        String allowedAnswers;
        Decision source = (Decision)((View)node.getContent()).getDefinition();
        JSITDecision d = new JSITDecision();
        d.setId(source.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        description.ifPresent(arg_0 -> ((JSITDecision)d).setDescription(arg_0));
        d.setName(source.getName().getValue());
        JSITInformationItem variable = InformationItemPrimaryPropertyConverter.dmnFromWB(source.getVariable(), (DMNModelInstrumentedBase)source);
        d.setVariable(variable);
        JSITExpression expression = ExpressionPropertyConverter.dmnFromWB(source.getExpression(), componentWidthsConsumer);
        d.setExpression(expression);
        String question = QuestionPropertyConverter.dmnFromWB(source.getQuestion());
        if (!StringUtils.isEmpty((String)question)) {
            d.setQuestion(question);
        }
        if (!StringUtils.isEmpty((String)(allowedAnswers = AllowedAnswersPropertyConverter.dmnFromWB(source.getAllowedAnswers())))) {
            d.setAllowedAnswers(allowedAnswers);
        }
        if (Objects.isNull(d.getInformationRequirement())) {
            d.setInformationRequirement(new ArrayList());
        }
        if (Objects.isNull(d.getKnowledgeRequirement())) {
            d.setKnowledgeRequirement(new ArrayList());
        }
        if (Objects.isNull(d.getAuthorityRequirement())) {
            d.setAuthorityRequirement(new ArrayList());
        }
        List inEdges = node.getInEdges();
        for (Edge e : inEdges) {
            JSITDMNElementReference ri;
            JSITInformationRequirement iReq;
            View view;
            Node sourceNode = e.getSourceNode();
            if (!(sourceNode.getContent() instanceof View) || !((view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement)) continue;
            DRGElement drgElement = (DRGElement)view.getDefinition();
            if (drgElement instanceof Decision) {
                iReq = new JSITInformationRequirement();
                iReq.setId(e.getUUID());
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredDecision(ri);
                d.addInformationRequirement(iReq);
                continue;
            }
            if (drgElement instanceof BusinessKnowledgeModel) {
                iReq = new JSITKnowledgeRequirement();
                iReq.setId(e.getUUID());
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredKnowledge(ri);
                d.addKnowledgeRequirement((JSITKnowledgeRequirement)iReq);
                continue;
            }
            if (drgElement instanceof KnowledgeSource) {
                iReq = new JSITAuthorityRequirement();
                iReq.setId(e.getUUID());
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredAuthority(ri);
                d.addAuthorityRequirement((JSITAuthorityRequirement)iReq);
                continue;
            }
            if (drgElement instanceof InputData) {
                iReq = new JSITInformationRequirement();
                iReq.setId(e.getUUID());
                ri = new JSITDMNElementReference();
                ri.setHref(HrefBuilder.getHref(drgElement));
                iReq.setRequiredInput(ri);
                d.addInformationRequirement(iReq);
                continue;
            }
            if (drgElement instanceof DecisionService) {
                if (e.getContent() instanceof Child) continue;
                if (e.getContent() instanceof View && ((View)e.getContent()).getDefinition() instanceof KnowledgeRequirement) {
                    iReq = new JSITKnowledgeRequirement();
                    iReq.setId(e.getUUID());
                    ri = new JSITDMNElementReference();
                    ri.setHref(HrefBuilder.getHref(drgElement));
                    iReq.setRequiredKnowledge(ri);
                    d.addKnowledgeRequirement((JSITKnowledgeRequirement)iReq);
                    continue;
                }
                throw new UnsupportedOperationException("wrong model definition.");
            }
            throw new UnsupportedOperationException("wrong model definition.");
        }
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (JSITDRGElement)d);
        return d;
    }
}

