/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jsinterop.base.Js;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.BindingPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.ExpressionPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.IdPropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.model.QNamePropertyConverter;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITBinding;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITExpression;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITInvocation;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.kie.JSITComponentWidths;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;

public class InvocationPropertyConverter {
    public static Invocation wbFromDMN(JSITInvocation dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        if (Objects.isNull(dmn)) {
            return null;
        }
        Id id = IdPropertyConverter.wbFromDMN(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        QName typeRef = QNamePropertyConverter.wbFromDMN(dmn.getTypeRef());
        Invocation result = new Invocation();
        result.setId(id);
        result.setDescription(description);
        result.setTypeRef(typeRef);
        Expression expression = null;
        JSITExpression jsiWrapped = dmn.getExpression();
        if (Objects.nonNull(jsiWrapped)) {
            JSITExpression jsiExpression = (JSITExpression)Js.uncheckedCast((Object)JsUtils.getUnwrappedElement((Object)jsiWrapped));
            expression = ExpressionPropertyConverter.wbFromDMN(jsiExpression, (JSITExpression)Js.uncheckedCast((Object)dmn), hasComponentWidthsConsumer);
        }
        result.setExpression(expression);
        if (Objects.nonNull(expression)) {
            expression.setParent((DMNModelInstrumentedBase)result);
        }
        List jsiBindings = dmn.getBinding();
        for (int i = 0; i < jsiBindings.size(); ++i) {
            JSITBinding jsiBinding = (JSITBinding)Js.uncheckedCast(jsiBindings.get(i));
            Binding bConverted = BindingPropertyConverter.wbFromDMN(jsiBinding, hasComponentWidthsConsumer);
            if (Objects.nonNull(bConverted)) {
                bConverted.setParent((DMNModelInstrumentedBase)result);
            }
            result.getBinding().add(bConverted);
        }
        return result;
    }

    public static JSITInvocation dmnFromWB(Invocation wb, Consumer<JSITComponentWidths> componentWidthsConsumer) {
        if (Objects.isNull(wb)) {
            return null;
        }
        JSITInvocation result = new JSITInvocation();
        result.setId(wb.getId().getValue());
        Optional<String> description = Optional.ofNullable(DescriptionPropertyConverter.dmnFromWB(wb.getDescription()));
        description.ifPresent(arg_0 -> ((JSITInvocation)result).setDescription(arg_0));
        QNamePropertyConverter.setDMNfromWB(wb.getTypeRef(), arg_0 -> ((JSITInvocation)result).setTypeRef(arg_0));
        JSITExpression convertedExpression = ExpressionPropertyConverter.dmnFromWB(wb.getExpression(), componentWidthsConsumer);
        result.setExpression(convertedExpression);
        for (Binding b : wb.getBinding()) {
            JSITBinding bConverted = BindingPropertyConverter.dmnFromWB(b, componentWidthsConsumer);
            result.addBinding(bConverted);
        }
        return result;
    }
}

